"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWithLock = void 0;
var debug_1 = __importDefault(require("debug"));
var debug = (0, debug_1.default)('@signageos/lib:AMQP:EventSourcing:Locked:withLock');
/**
 * Create a function waitLock that will use the deferredState for managing the deferred promises.
 *
 * It will wait for all previous promises with the same lock-keys to finish before executing the callback.
 * If the callback throws an error, all subsequent waiting promises with the same lock-keys will be rejected.
 */
var createWithLock = function (deferredState) { return function (lockKeys, callback) { return __awaiter(void 0, void 0, void 0, function () {
    var previousPromises, currentDeferred, error_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                previousPromises = deferredState.getPreviousPromises(lockKeys);
                currentDeferred = deferredState.addDeferred(lockKeys);
                _a.label = 1;
            case 1:
                _a.trys.push([1, , 7, 8]);
                // Wait for all previous promises with the same lock-keys to finish
                return [4 /*yield*/, Promise.all(previousPromises)];
            case 2:
                // Wait for all previous promises with the same lock-keys to finish
                _a.sent();
                _a.label = 3;
            case 3:
                _a.trys.push([3, 5, , 6]);
                debug('Starting locked callback', { lockKeys: lockKeys });
                return [4 /*yield*/, callback()];
            case 4:
                _a.sent();
                debug('Finished locked callback', { lockKeys: lockKeys });
                // Resolve the current deferred to allow the next promise to proceed
                currentDeferred.resolve();
                return [3 /*break*/, 6];
            case 5:
                error_1 = _a.sent();
                debug('Error in locked callback', { lockKeys: lockKeys, error: error_1 });
                // Reject all subsequent waiting promises with the same lock-keys in the same order
                currentDeferred.reject(new Error("Previous promise with same lock-key failed, rejecting all subsequent waiting promises."));
                // Because of call stack of JS, following error will be thrown and promise rejected first, before the above rejected promise
                throw error_1;
            case 6: return [3 /*break*/, 8];
            case 7:
                deferredState.removeDeferred(lockKeys, currentDeferred);
                return [7 /*endfinally*/];
            case 8: return [2 /*return*/];
        }
    });
}); }; };
exports.createWithLock = createWithLock;
//# sourceMappingURL=withLock.js.map