import { DeferredState } from './deferredState';
export type WithLock = (lockKeys: string[], callback: () => Promise<void>) => Promise<void>;
/**
 * Create a function waitLock that will use the deferredState for managing the deferred promises.
 *
 * It will wait for all previous promises with the same lock-keys to finish before executing the callback.
 * If the callback throws an error, all subsequent waiting promises with the same lock-keys will be rejected.
 */
export declare const createWithLock: (deferredState: DeferredState) => (lockKeys: string[], callback: () => Promise<void>) => Promise<void>;
