import { promises as fs } from 'fs';
import { detectIndent, PackageJson, PackageLockJson, readJSON } from './helper';

(async () => {
	const packagePath = process.cwd() + '/package.json';
	const packageLockPath = process.cwd() + '/package-lock.json';
	const pkg: PackageJson = await readJSON(packagePath);
	const packageLock: PackageLockJson = await readJSON(packageLockPath).catch(() => null);

	const nextVersion = process.argv[2];
	if (!nextVersion) {
		throw new Error('No version specified');
	}
	pkg.version = nextVersion;
	if (packageLock) {
		packageLock.version = nextVersion;
		if (packageLock.packages && packageLock.packages['']) {
			packageLock.packages[''].version = nextVersion;
		}
	}

	const indentChar = await detectIndent(packagePath);
	await fs.writeFile(packagePath, JSON.stringify(pkg, null, indentChar) + '\n');
	if (packageLock) {
		await fs.writeFile(packageLockPath, JSON.stringify(packageLock, null, indentChar) + '\n');
	}
})();
