#!/usr/bin/env node

import { promises as fs } from 'fs';
import { detectIndent, PackageJson, PackageLockJson, readJSON } from './helper';

function exactDepsMutable(deps: Record<string, string>, lock: PackageLockJson) {
	deps = deps || {};
	const depNames = Object.keys(deps);
	for (const depName of depNames) {
		const lockDep = lock.dependencies[depName];
		if (!lockDep) {
			throw new Error('package-lock.json is outdated');
		}
		const currentVersion = lockDep.version;
		deps[depName] = currentVersion;
	}
}

(async () => {
	const packagePath = process.cwd() + '/package.json';
	const packageLockPath = process.cwd() + '/package-lock.json';
	const pkg: PackageJson = await readJSON(packagePath);
	const packageLock: PackageLockJson = await readJSON(packageLockPath);

	exactDepsMutable(pkg.dependencies, packageLock);
	exactDepsMutable(pkg.devDependencies, packageLock);

	const indentChar = await detectIndent(packagePath);
	await fs.writeFile(packagePath, JSON.stringify(pkg, undefined, indentChar) + '\n');
})();
