export enum ChangeLogEntry {
	Changed = 'Changed',
	Removed = 'Removed',
	Added = 'Added',
	Fixed = 'Fixed',
	Security = 'Security',
	Deprecated = 'Deprecated',
}

export const isValidChangeLogEntry = (x: unknown): x is ChangeLogEntry => !!(ChangeLogEntry as any)[x as any];

export const allChangelogEntries = Object.values(ChangeLogEntry);
