#!/usr/bin/env node
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var import_semver = __toESM(require("semver"));
var import_utils = require("./utils.js");
(() => __async(exports, null, function* () {
  const packagePath = process.cwd() + "/package.json";
  const pkg = yield (0, import_utils.readJSON)(packagePath);
  const ignorePath = process.cwd() + "/.check-depsignore";
  let ignore = [];
  try {
    ignore = yield (0, import_utils.readJSON)(ignorePath);
    console.log(`Ignoring packages from ${ignorePath}`);
  } catch (_error) {
    console.log("No ignore file found");
  }
  const runControlPath = process.cwd() + "/.check-depsrc.json";
  let runControl;
  try {
    runControl = yield (0, import_utils.readJSON)(runControlPath);
    console.log(`Using run control from ${runControlPath}`);
    if (runControl.ignores) {
      ignore = ignore.concat(runControl.ignores);
    }
  } catch (error) {
    console.log("No Run Control file found");
  }
  const includeRegExp = new RegExp(process.argv[2] || ".+");
  const excludeRegExp = new RegExp(process.argv[3] || "^$");
  const deps = __spreadValues(__spreadValues({}, pkg.dependencies || {}), pkg.devDependencies || {});
  const depNames = Object.keys(deps);
  const matchedDepNames = depNames.filter((depName) => includeRegExp.test(depName) && !excludeRegExp.test(depName));
  const prereleaseDepNames = [];
  const inexactDepNames = [];
  const expectedRangeDepNames = [];
  function isExpectedRangeValid(depName, version) {
    return version.startsWith(runControl == null ? void 0 : runControl.expectRanges[depName]);
  }
  for (const depName of matchedDepNames) {
    if (ignore.includes(depName)) {
      continue;
    }
    const depVersion = deps[depName];
    const minVersion = import_semver.default.minVersion(depVersion);
    if (!minVersion) {
      throw new Error(`Invalid depversion ${depVersion}`);
    }
    if (import_semver.default.prerelease(minVersion) !== null) {
      prereleaseDepNames.push(depName);
    }
    if ((runControl == null ? void 0 : runControl.expectRanges) && depName in runControl.expectRanges) {
      if (!isExpectedRangeValid(depName, depVersion)) {
        expectedRangeDepNames.push(depName);
      }
    } else {
      if (!import_semver.default.valid(depVersion)) {
        inexactDepNames.push(depName);
      }
    }
  }
  if (prereleaseDepNames.length > 0) {
    const prereleaseDeps = {};
    prereleaseDepNames.forEach((depName) => {
      prereleaseDeps[depName] = deps[depName];
    });
    console.error(`Some packages has prerelease tags in version in package.json deps`, prereleaseDepNames.join(", "), prereleaseDeps);
  }
  if (expectedRangeDepNames.length > 0) {
    const expectedRangeDeps = {};
    expectedRangeDepNames.forEach((depName) => {
      expectedRangeDeps[depName] = deps[depName];
    });
    console.error(
      `Some packages has expectation of range of versions specified in package.json deps`,
      expectedRangeDepNames.map((depName) => `${depName}->"${runControl == null ? void 0 : runControl.expectRanges[depName]}"`).join(", "),
      expectedRangeDeps
    );
  }
  if (inexactDepNames.length > 0) {
    const inexactDeps = {};
    inexactDepNames.forEach((depName) => {
      inexactDeps[depName] = deps[depName];
    });
    console.error(`Some packages has not exact version specified in package.json deps`, inexactDepNames.join(", "), inexactDeps);
  }
  if (prereleaseDepNames.length > 0 || expectedRangeDepNames.length > 0 || inexactDepNames.length > 0) {
    process.exit(1);
  }
}))();
