import { z } from 'zod';
/**
 * List of all possible supported ABIs.
 */
export declare const Abis: readonly ["x86", "x86_64", "armeabi-v7a", "arm64-v8a"];
/** It can be alternatively any string because it's dynamic value and depends on device */
declare const AbiSchema: z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>;
export type Abi = z.infer<typeof AbiSchema>;
export declare const AndroidIdentificationSpecsSchema: z.ZodObject<{
    /**
     * Internal package name of android application.
     * Java notation, e.g.: io.signageos.android
     */
    packageName: z.ZodString;
}, "strip", z.ZodTypeAny, {
    packageName: string;
}, {
    packageName: string;
}>;
export type AndroidIdentificationSpecs = z.infer<typeof AndroidIdentificationSpecsSchema>;
export declare const AndroidPackageSpecsSchema: z.ZodObject<{
    /**
     * Application ID as specified in the APK manifest, i.e. `com.example.app`.
     * See [definition](https://developer.android.com/guide/topics/manifest/manifest-element#package).
     */
    packageName: z.ZodString;
    /**
     * Min SDK version as specified in the APK manifest.
     * See [definition](https://developer.android.com/guide/topics/manifest/uses-sdk-element#target).
     */
    sdkVersion: z.ZodNumber;
    /**
     * List of supported ABIs.
     * If the package doesn't contain any native code (and can run on any CPU) this will be `undefined`.
     * Read more about [Android ABIs](https://developer.android.com/ndk/guides/abis).
     */
    supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
    /**
     * - `true`: This APK may be loaded as a library by other apps.
     *   In practice, it needs to provide 32-bit native code
     *   on 64-bit devices capable of running in 32-bit mode.
     *   Can ony be installed on devices that support *all* of {@link supportedAbis}.
     *   An example of such app is the WebView.
     * - `false` (default): This is a standalone APK.
     *   Can be installed on devices that support *any* of {@link supportedAbis}.
     */
    multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
    /**
     * Version code as specifed in the APK manifest.
     * See [definition](https://developer.android.com/guide/topics/manifest/manifest-element#vcode).
     */
    versionCode: z.ZodOptional<z.ZodNumber>;
    /**
     * Target SDK version as specified in the APK manifest.
     * See [definition](https://developer.android.com/guide/topics/manifest/uses-sdk-element#target).
     */
    targetSdkVersion: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    packageName: string;
    sdkVersion: number;
    supportedAbis?: string[] | undefined;
    multiArch?: boolean | null | undefined;
    versionCode?: number | undefined;
    targetSdkVersion?: number | undefined;
}, {
    packageName: string;
    sdkVersion: number;
    supportedAbis?: string[] | undefined;
    multiArch?: boolean | null | undefined;
    versionCode?: number | undefined;
    targetSdkVersion?: number | undefined;
}>;
export type AndroidPackageSpecs = z.infer<typeof AndroidPackageSpecsSchema>;
export declare const AndroidInstallationFromUriSpecsSchema: z.ZodObject<{
    /** `packageName` as defined by the APK manifest, i.e. com.example.app */
    packageName: z.ZodString;
    /** SHA-256 hash of the APK file. */
    apkSha256: z.ZodOptional<z.ZodString>;
    /**
     * SHA-256 hash of the APK signature.
     * Older Core Apps did not have this field, so it can be omitted.
     */
    signatureSha256: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    packageName: string;
    apkSha256?: string | undefined;
    signatureSha256?: string | undefined;
}, {
    packageName: string;
    apkSha256?: string | undefined;
    signatureSha256?: string | undefined;
}>;
export type AndroidInstallationFromUriSpecs = z.infer<typeof AndroidInstallationFromUriSpecsSchema>;
/**
 * The specifications of installed android package (APK file).
 * It contains extra information specific only for the android platform (applicationType).
 * Some of those can be used as a source for buildHash computation.
 */
export declare const AndroidInstalledSpecsSchema: z.ZodObject<{
    /** `packageName` as defined by the APK manifest, i.e. com.example.app */
    packageName: z.ZodString;
    /** `versionCode` as defined by the APK manifest, i.e. 200050 */
    versionCode: z.ZodNumber;
    /** SHA-256 hash of the APK file. */
    apkSha256: z.ZodString;
    /**
     * `versionName` as defined by the APK manifest, i.e. 2.3.0.
     * Older Core Apps did not have this field, so it can be omitted.
     */
    versionName: z.ZodOptional<z.ZodString>;
    /**
     * SHA-256 hash of the APK signature.
     * Older Core Apps did not have this field, so it can be omitted.
     */
    signatureSha256: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    packageName: string;
    versionCode: number;
    apkSha256: string;
    signatureSha256?: string | undefined;
    versionName?: string | undefined;
}, {
    packageName: string;
    versionCode: number;
    apkSha256: string;
    signatureSha256?: string | undefined;
    versionName?: string | undefined;
}>;
export type AndroidInstalledSpecs = z.infer<typeof AndroidInstalledSpecsSchema>;
export {};
