export declare const UID_LENGTH = 36;
export declare const UID_CHARACTERS = "0123456789abcdef";
/**
 * Generate a globally unique UID.
 *
 * Generated UIDs are 36 characters long and consist of the characters '0123456789abcdef'.
 * This is the format approved for use across the entire platform, for all entities.
 *
 * UID is generated using library `nanoid`
 * @see https://www.npmjs.com/package/nanoid
 */
export declare const generateUid: (size?: number) => string;
