"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidManagementCapabilities = void 0;
exports.default = validateManagementCapabilitiesTelemetry;
exports.isArrayOfManagementCapabilities = isArrayOfManagementCapabilities;
const Validation_1 = require("../../../Validation/Validation");
const ManagementCapabilities_1 = require("../../../Device/Capabilities/ManagementCapabilities");
function validateManagementCapabilitiesTelemetry(settings) {
    var _a;
    const { capable } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidManagementCapabilities = !isArrayOfManagementCapabilities(capable);
    const validation = (0, Validation_1.createValidation)(settings);
    if (notValidManagementCapabilities) {
        validation.addError(new InvalidManagementCapabilities(capable));
    }
    return validation.getOutput();
}
function isArrayOfManagementCapabilities(capable) {
    const possibleValues = Object.values(ManagementCapabilities_1.ManagementCapabilities);
    return Array.isArray(capable) && capable.filter((value) => !possibleValues.includes(value)).length === 0;
}
class InvalidManagementCapabilities extends Error {
    constructor(_capable) {
        super('management capabilities have to be array of valid management capabilities');
    }
}
exports.InvalidManagementCapabilities = InvalidManagementCapabilities;
