"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevicePackageInstallationFromUriSchema = exports.AndroidDevicePackageInstallationFromUriSchema = exports.TizenDevicePackageInstallationFromUriSchema = void 0;
const zod_1 = require("zod");
const ApplicationType_1 = require("../../Application/ApplicationType");
const specs_1 = require("../../Package/Android/specs");
const BaseDevicePackageInstallationFromUri = zod_1.z.strictObject({
    applicationType: ApplicationType_1.ApplicationTypeSchema,
    /** Direct URI to package file */
    packageUri: zod_1.z.string(),
    specs: zod_1.z.object({}),
});
exports.TizenDevicePackageInstallationFromUriSchema = BaseDevicePackageInstallationFromUri.extend({
    applicationType: zod_1.z.literal('tizen'),
    /** Tizen doesn't require any additional specs */
    specs: zod_1.z.never().optional(),
});
exports.AndroidDevicePackageInstallationFromUriSchema = BaseDevicePackageInstallationFromUri.extend({
    applicationType: zod_1.z.literal('android'),
    /**
     * Platform specific information differs for each application type.
     * Contains unique hash (usually checksum of package file) which is unique for every build.
     * Core App will validate the checksum before package is installed and fail if doesn't match.
     * If specs are not provided, Core App will install the package without validation.
     */
    specs: specs_1.AndroidInstallationFromUriSpecsSchema.optional(),
});
exports.DevicePackageInstallationFromUriSchema = zod_1.z.discriminatedUnion('applicationType', [
    exports.AndroidDevicePackageInstallationFromUriSchema,
    exports.TizenDevicePackageInstallationFromUriSchema,
]);
