"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevicePackageInstallationSchema = exports.AndroidDevicePackageInstallationSchema = void 0;
const zod_1 = require("zod");
const ApplicationType_1 = require("../../Application/ApplicationType");
const specs_1 = require("../../Package/Android/specs");
const BaseDevicePackageInstallationSchema = zod_1.z.strictObject({
    applicationType: ApplicationType_1.ApplicationTypeSchema,
    /**
     * Proprietary package name (platform independent)
     */
    packageName: zod_1.z.string(),
    /**
     * organization uid which is a part of URL to download package
     */
    ownerOrganizationUid: zod_1.z.string(),
    /**
     * Contains unique hash (usually checksum of package file) which is unique for every build
     * E.g.:
     * Android - apk file sha256 (equal to specs.apkSha256)
     * TODO other platforms
     */
    buildHash: zod_1.z.string(),
    /**
     * Human readable version name
     * It's usually uniq for package real version but usually it's same for different builds (architectures)
     */
    version: zod_1.z.string(),
    /**
     * Additional postfix of version to recognize different builds
     * Used for back compatibility in old android packages
     */
    build: zod_1.z.string().nullable(),
    /**
     * Platform specific information differs for each application type
     */
    specs: zod_1.z.object({}),
});
exports.AndroidDevicePackageInstallationSchema = BaseDevicePackageInstallationSchema.extend({
    applicationType: zod_1.z.literal('android'),
    specs: specs_1.AndroidPackageSpecsSchema,
});
exports.DevicePackageInstallationSchema = exports.AndroidDevicePackageInstallationSchema;
