import { z } from 'zod';
export declare enum ValueType {
    String = "string",
    Url = "url",
    Enum = "enum",
    Number = "number",
    Secret = "secret",
    Unknown = "unknown",
    Encrypted = "encrypted"
}
export declare const BaseDataSchema: z.ZodObject<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name: string;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>;
export declare const StringSchema: z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.String>;
    maxLength: z.ZodOptional<z.ZodNumber>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.String;
    description?: string | undefined;
    maxLength?: number | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.String;
    description?: string | undefined;
    maxLength?: number | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>;
export type StringConfigurationDefinition = z.infer<typeof StringSchema>;
export declare const UrlSchema: z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Url>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Url;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Url;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>;
export type UrlConfigurationDefinition = z.infer<typeof UrlSchema>;
export declare const EnumSchema: z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Enum>;
    list: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Enum;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
    list?: (string | number)[] | undefined;
}, {
    name: string;
    valueType: ValueType.Enum;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
    list?: (string | number)[] | undefined;
}>;
export type EnumConfigurationDefinition = z.infer<typeof EnumSchema>;
export declare const NumberSchema: z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Number>;
    min: z.ZodOptional<z.ZodNumber>;
    max: z.ZodOptional<z.ZodNumber>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Number;
    max?: number | undefined;
    min?: number | undefined;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Number;
    max?: number | undefined;
    min?: number | undefined;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>;
export type NumberConfigurationDefinition = z.infer<typeof NumberSchema>;
export declare const SecretSchema: z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Secret>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Secret;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Secret;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>;
export type SecretConfigurationDefinition = z.infer<typeof SecretSchema>;
export declare const UnknownSchema: z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Unknown>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Unknown;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Unknown;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>;
export type UnknownConfigurationDefinition = z.infer<typeof UnknownSchema>;
export declare const EncryptedSchema: z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Encrypted>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Encrypted;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Encrypted;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>;
export type EncryptedConfigurationDefinition = z.infer<typeof EncryptedSchema>;
export declare const ConfigDefinitionSchema: z.ZodDiscriminatedUnion<"valueType", [z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.String>;
    maxLength: z.ZodOptional<z.ZodNumber>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.String;
    description?: string | undefined;
    maxLength?: number | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.String;
    description?: string | undefined;
    maxLength?: number | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Url>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Url;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Url;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Enum>;
    list: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Enum;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
    list?: (string | number)[] | undefined;
}, {
    name: string;
    valueType: ValueType.Enum;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
    list?: (string | number)[] | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Number>;
    min: z.ZodOptional<z.ZodNumber>;
    max: z.ZodOptional<z.ZodNumber>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Number;
    max?: number | undefined;
    min?: number | undefined;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Number;
    max?: number | undefined;
    min?: number | undefined;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Secret>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Secret;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Secret;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Unknown>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Unknown;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Unknown;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    mandatory: z.ZodOptional<z.ZodBoolean>;
    placeholder: z.ZodOptional<z.ZodString>;
}, {
    valueType: z.ZodLiteral<ValueType.Encrypted>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    valueType: ValueType.Encrypted;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}, {
    name: string;
    valueType: ValueType.Encrypted;
    description?: string | undefined;
    mandatory?: boolean | undefined;
    placeholder?: string | undefined;
}>]>;
export type ConfigDefinition = z.infer<typeof ConfigDefinitionSchema>;
