"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidEmailAddressesInAlertAction = exports.InvalidAccountsInAlertAction = exports.InvalidAlertActionType = exports.InvalidAlertActionInput = exports.alertActionTypes = void 0;
exports.default = isAlertActionValid;
const Validation_1 = require("../../Validation/Validation");
const getKeys_1 = require("../../Validation/getKeys");
exports.alertActionTypes = ['accounts', 'organization_accounts', 'emailAddresses'];
function isAlertActionValid(action) {
    var _a;
    const validation = (0, Validation_1.createValidation)({});
    const alertAction = (_a = action) !== null && _a !== void 0 ? _a : null;
    const isValidObject = typeof alertAction === 'object' && (0, getKeys_1.default)(alertAction).includes('type');
    if (isValidObject) {
        if (exports.alertActionTypes.includes(alertAction.type)) {
            switch (alertAction.type) {
                case 'accounts': {
                    const isValidAccounts = alertAction.accountIds && Array.isArray(alertAction.accountIds);
                    if (!isValidAccounts) {
                        validation.addError(new InvalidAccountsInAlertAction(alertAction.accountIds));
                    }
                    break;
                }
                case 'emailAddresses': {
                    const isValidEmailAddresses = alertAction.emailAddresses && Array.isArray(alertAction.emailAddresses);
                    if (!isValidEmailAddresses) {
                        validation.addError(new InvalidEmailAddressesInAlertAction(alertAction.emailAddresses));
                    }
                    break;
                }
            }
        }
        else {
            validation.addError(new InvalidAlertActionType(alertAction));
        }
    }
    else {
        validation.addError(new InvalidAlertActionInput(alertAction));
    }
    return validation.getOutput();
}
class InvalidAlertActionInput extends Error {
    constructor(type) {
        super(`Alert action is not valid input: ${JSON.stringify(type)}`);
    }
}
exports.InvalidAlertActionInput = InvalidAlertActionInput;
class InvalidAlertActionType extends Error {
    constructor(type) {
        super(`Alert action type is not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidAlertActionType = InvalidAlertActionType;
class InvalidAccountsInAlertAction extends Error {
    constructor(type) {
        super(`AccountIds in alert action are not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidAccountsInAlertAction = InvalidAccountsInAlertAction;
class InvalidEmailAddressesInAlertAction extends Error {
    constructor(type) {
        super(`Email addresses in alert action are not valid: ${JSON.stringify(type)}`);
    }
}
exports.InvalidEmailAddressesInAlertAction = InvalidEmailAddressesInAlertAction;
