import { ResolutionItem } from '../Device/Resolution/ResolutionList';
import { TimerSettings, OrientationSettings, PowerActionsScheduleSettings, ProprietaryTimerSettings } from '../Device/Settings/DeviceSettings';
import { DeviceSettingsType } from '../Device/Settings/DeviceSettingsType';
import { AlertType } from './AlertType';
/** Device related condition types */
export declare const DeviceConditionType: {
    /** Is used when device has incorrect time based on current time & timezone of device */
    readonly INCORRECT_TIME: "INCORRECT_TIME";
    /** Is used when device is detected having some problems with SSL certificates (it can be even time related) */
    readonly INVALID_SSL_CERTIFICATE: "INVALID_SSL_CERTIFICATE";
    /** Is used when device performing/executing action has failed for amount of time in past */
    readonly FAILED_ACTIONS: "FAILED_ACTIONS";
    /** Connection status of device. Check if device is currently connected or not. Additionally ALIVE_AT available */
    readonly CONNECTIONS: "CONNECTIONS";
    /** Check if device has model or not */
    readonly MODEL: "MODEL";
    /** Check if device has serial number or not */
    readonly SERIAL_NUMBER: "SERIAL_NUMBER";
    /** Check if device partially match some string */
    readonly NAME: "NAME";
    /** Check if device has PIN code reported */
    readonly PIN_CODE: "PIN_CODE";
    /** Check if device match semver version */
    readonly MANAGEMENT_PACKAGE_VERSION: "MANAGEMENT_PACKAGE_VERSION";
    /** Check if device match semver version */
    readonly FRONT_PACKAGE_VERSION: "FRONT_PACKAGE_VERSION";
    /** Check if device match semver version */
    readonly FRONT_DISPLAY_VERSION: "FRONT_DISPLAY_VERSION";
    /** Check if device partially match some string */
    readonly FIRMWARE_TYPE: "FIRMWARE_TYPE";
    /** Check if device has selected tags */
    readonly TAG_UIDS: "TAG_UIDS";
    /** Check if device has selected policy settings */
    readonly POLICIES: "POLICIES";
    /** Check if device was provisioned in specified time range in past. Useful to detect new devices are provisioned */
    readonly LAST_PROVISION_AT: "LAST_PROVISION_AT";
    /** Check if device was deprovisioned in specified time range in past. Useful to detect devices are re-provisioned */
    readonly LAST_DEPROVISION_AT: "LAST_DEPROVISION_AT";
    /** Check if device has access to extended management */
    readonly EXTENDED_MANAGEMENT: "EXTENDED_MANAGEMENT";
    /** Check if device last ping in specified time range in past. */
    readonly ALIVE_AT: "ALIVE_AT";
    /** Check if device is connected using WiFi or Ethernet */
    readonly NETWORK_INTERFACES: "NETWORK_INTERFACES";
    /** Check if device has enough or not enough battery */
    readonly BATTERY_STATUS: "BATTERY_STATUS";
    /** Check if device has or has not enough free storage */
    readonly STORAGE_STATUS: "STORAGE_STATUS";
    /** Check if timezone match the string */
    readonly CURRENT_TIMEZONE: "CURRENT_TIMEZONE";
    /** Check if match expected value of display settings */
    readonly DISPLAY_SETTING_BACKLIGHT: "DISPLAY_SETTING_BACKLIGHT";
    readonly DISPLAY_SETTING_CONTRAST: "DISPLAY_SETTING_CONTRAST";
    readonly DISPLAY_SETTING_SHARPNESS: "DISPLAY_SETTING_SHARPNESS";
    /** mas temperature in celsius */
    readonly DISPLAY_SETTING_MAX_TEMPERATURE: "DISPLAY_SETTING_MAX_TEMPERATURE";
    /** Check if current input source is set to specified source */
    readonly INPUT_SOURCE: "INPUT_SOURCE";
    /** Check if current volume is expected */
    readonly VOLUME: "VOLUME";
    /** Check if current brightness is expected */
    readonly BRIGHTNESS: "BRIGHTNESS";
    /** Check if current native timers are set as expected */
    readonly TIMERS: "TIMERS";
    /** Check if current proprietary timers are set as expected */
    readonly PROPRIETARY_TIMERS: "PROPRIETARY_TIMERS";
    /** Check if current resolution is set as expected */
    readonly RESOLUTION: "RESOLUTION";
    /** Check if current orientation is set as expected */
    readonly ORIENTATION: "ORIENTATION";
    /** Check if current RC is locked or not */
    readonly REMOTE_CONTROL: "REMOTE_CONTROL";
    /** Check if current core app version is correct */
    readonly APPLICATION_VERSION: "APPLICATION_VERSION";
    /** Check if current FW version match some string */
    readonly FIRMWARE_VERSION: "FIRMWARE_VERSION";
    /** Check if debug is enabled or not */
    readonly DEBUG: "DEBUG";
    /** Check if current scheduled power actions are correctly set */
    readonly POWER_ACTIONS_SCHEDULE: "POWER_ACTIONS_SCHEDULE";
    /** Check if temperature is in specified range in celsius */
    readonly TEMPERATURE: "TEMPERATURE";
    /** Check if specified package is installed */
    readonly INSTALLED_PACKAGE: "INSTALLED_PACKAGE";
    /** Check if number of screenshots was received in time */
    readonly SCREENSHOT: "SCREENSHOT";
    /** Check if feature tests has passed */
    readonly FEATURE_TESTS: "FEATURE_TESTS";
};
/**
 * Policy related condition types.
 * It contains violation of any of existing policy device settings type.
 * Copied from @signageos/common/devices library
 */
export declare const PolicyConditionType: {
    readonly POLICY_VIOLATION_VOLUME: "POLICY_VIOLATION_VOLUME";
    readonly POLICY_VIOLATION_BRIGHTNESS: "POLICY_VIOLATION_BRIGHTNESS";
    readonly POLICY_VIOLATION_TIMERS: "POLICY_VIOLATION_TIMERS";
    readonly POLICY_VIOLATION_PROPRIETARY_TIMERS: "POLICY_VIOLATION_PROPRIETARY_TIMERS";
    readonly POLICY_VIOLATION_RESOLUTION: "POLICY_VIOLATION_RESOLUTION";
    readonly POLICY_VIOLATION_ORIENTATION: "POLICY_VIOLATION_ORIENTATION";
    readonly POLICY_VIOLATION_REMOTE_CONTROL: "POLICY_VIOLATION_REMOTE_CONTROL";
    readonly POLICY_VIOLATION_APPLICATION_VERSION: "POLICY_VIOLATION_APPLICATION_VERSION";
    readonly POLICY_VIOLATION_FIRMWARE_VERSION: "POLICY_VIOLATION_FIRMWARE_VERSION";
    readonly POLICY_VIOLATION_DEBUG: "POLICY_VIOLATION_DEBUG";
    readonly POLICY_VIOLATION_DATETIME: "POLICY_VIOLATION_DATETIME";
    readonly POLICY_VIOLATION_POWER_ACTIONS_SCHEDULE: "POLICY_VIOLATION_POWER_ACTIONS_SCHEDULE";
    readonly POLICY_VIOLATION_TEMPERATURE: "POLICY_VIOLATION_TEMPERATURE";
};
/** Applet related condition types */
export declare const AppletConditionType: {
    /** Is used when to check custom user defined commands occurrences in time */
    readonly APPLET_COMMAND: "APPLET_COMMAND";
};
/** Union of all condition types */
export declare const ConditionType: {
    APPLET_COMMAND: "APPLET_COMMAND";
    POLICY_VIOLATION_VOLUME: "POLICY_VIOLATION_VOLUME";
    POLICY_VIOLATION_BRIGHTNESS: "POLICY_VIOLATION_BRIGHTNESS";
    POLICY_VIOLATION_TIMERS: "POLICY_VIOLATION_TIMERS";
    POLICY_VIOLATION_PROPRIETARY_TIMERS: "POLICY_VIOLATION_PROPRIETARY_TIMERS";
    POLICY_VIOLATION_RESOLUTION: "POLICY_VIOLATION_RESOLUTION";
    POLICY_VIOLATION_ORIENTATION: "POLICY_VIOLATION_ORIENTATION";
    POLICY_VIOLATION_REMOTE_CONTROL: "POLICY_VIOLATION_REMOTE_CONTROL";
    POLICY_VIOLATION_APPLICATION_VERSION: "POLICY_VIOLATION_APPLICATION_VERSION";
    POLICY_VIOLATION_FIRMWARE_VERSION: "POLICY_VIOLATION_FIRMWARE_VERSION";
    POLICY_VIOLATION_DEBUG: "POLICY_VIOLATION_DEBUG";
    POLICY_VIOLATION_DATETIME: "POLICY_VIOLATION_DATETIME";
    POLICY_VIOLATION_POWER_ACTIONS_SCHEDULE: "POLICY_VIOLATION_POWER_ACTIONS_SCHEDULE";
    POLICY_VIOLATION_TEMPERATURE: "POLICY_VIOLATION_TEMPERATURE";
    INCORRECT_TIME: "INCORRECT_TIME";
    INVALID_SSL_CERTIFICATE: "INVALID_SSL_CERTIFICATE";
    FAILED_ACTIONS: "FAILED_ACTIONS";
    CONNECTIONS: "CONNECTIONS";
    MODEL: "MODEL";
    SERIAL_NUMBER: "SERIAL_NUMBER";
    NAME: "NAME";
    PIN_CODE: "PIN_CODE";
    MANAGEMENT_PACKAGE_VERSION: "MANAGEMENT_PACKAGE_VERSION";
    FRONT_PACKAGE_VERSION: "FRONT_PACKAGE_VERSION";
    FRONT_DISPLAY_VERSION: "FRONT_DISPLAY_VERSION";
    FIRMWARE_TYPE: "FIRMWARE_TYPE";
    TAG_UIDS: "TAG_UIDS";
    POLICIES: "POLICIES";
    LAST_PROVISION_AT: "LAST_PROVISION_AT";
    LAST_DEPROVISION_AT: "LAST_DEPROVISION_AT";
    EXTENDED_MANAGEMENT: "EXTENDED_MANAGEMENT";
    ALIVE_AT: "ALIVE_AT";
    NETWORK_INTERFACES: "NETWORK_INTERFACES";
    BATTERY_STATUS: "BATTERY_STATUS";
    STORAGE_STATUS: "STORAGE_STATUS";
    CURRENT_TIMEZONE: "CURRENT_TIMEZONE";
    DISPLAY_SETTING_BACKLIGHT: "DISPLAY_SETTING_BACKLIGHT";
    DISPLAY_SETTING_CONTRAST: "DISPLAY_SETTING_CONTRAST";
    DISPLAY_SETTING_SHARPNESS: "DISPLAY_SETTING_SHARPNESS";
    DISPLAY_SETTING_MAX_TEMPERATURE: "DISPLAY_SETTING_MAX_TEMPERATURE";
    INPUT_SOURCE: "INPUT_SOURCE";
    VOLUME: "VOLUME";
    BRIGHTNESS: "BRIGHTNESS";
    TIMERS: "TIMERS";
    PROPRIETARY_TIMERS: "PROPRIETARY_TIMERS";
    RESOLUTION: "RESOLUTION";
    ORIENTATION: "ORIENTATION";
    REMOTE_CONTROL: "REMOTE_CONTROL";
    APPLICATION_VERSION: "APPLICATION_VERSION";
    FIRMWARE_VERSION: "FIRMWARE_VERSION";
    DEBUG: "DEBUG";
    POWER_ACTIONS_SCHEDULE: "POWER_ACTIONS_SCHEDULE";
    TEMPERATURE: "TEMPERATURE";
    INSTALLED_PACKAGE: "INSTALLED_PACKAGE";
    SCREENSHOT: "SCREENSHOT";
    FEATURE_TESTS: "FEATURE_TESTS";
};
/** Kinds of conditions which defines operands and operators, and deduce which mathematical operation will be used in matching */
export declare enum ConditionKind {
    BOOLEAN = "BOOLEAN",
    OCCURRENCES_IN_TIME_RANGE_TO_PAST = "OCCURRENCES_IN_TIME_RANGE_TO_PAST",
    STRING_OCCURRENCES_IN_TIME_RANGE_TO_PAST = "STRING_OCCURRENCES_IN_TIME_RANGE_TO_PAST",
    TIME_RANGE_TO_PAST = "TIME_RANGE_TO_PAST",
    PERCENTAGE_RANGE = "PERCENTAGE_RANGE",
    NUMERIC_RANGE = "NUMERIC_RANGE",
    MATCH_STRING = "MATCH_STRING",
    MATCH_SEMVER = "MATCH_SEMVER",
    STRING_LIST = "STRING_LIST",
    POLICY_LIST = "POLICY_LIST",
    WIFI_OR_ETHERNET = "WIFI_OR_ETHERNET",
    INPUT_SOURCE = "INPUT_SOURCE",
    TIMERS = "TIMERS",
    PROPRIETARY_TIMERS = "PROPRIETARY_TIMERS",
    RESOLUTION = "RESOLUTION",
    ORIENTATION = "ORIENTATION",
    SCHEDULED_POWER_ACTIONS = "SCHEDULED_POWER_ACTIONS"
}
/** All possible numeric operators for numeric condition kinds */
export type NumericOperator = '>' | '<' | '<=' | '>=' | '=' | '!=';
/** All possible semver operators for semver condition kinds (same operations as numeric) */
export type SemverOperator = NumericOperator;
/** All possible range operators to select time period until or since given moment in past */
export type TimeRangeOperator = '>' | '<';
/** All available values for specific condition kinds */
export type ConditionOpMap = {
    /** Condition is checking if it applies for device or not */
    [ConditionKind.BOOLEAN]: boolean;
    /** Condition is checking if total number of occurrences is <>= for the last amount of time specified in periodicity */
    [ConditionKind.OCCURRENCES_IN_TIME_RANGE_TO_PAST]: [operator: NumericOperator, occurrences: number, rangeInPastMs: number];
    /** Condition is checking if total number of exact string occurrences is <>= for the last amount of time specified in periodicity */
    [ConditionKind.STRING_OCCURRENCES_IN_TIME_RANGE_TO_PAST]: [
        str: string,
        operator: NumericOperator,
        occurrences: number,
        rangeInPastMs: number
    ];
    [ConditionKind.TIME_RANGE_TO_PAST]: [operator: TimeRangeOperator, rangeInPastMs: number];
    [ConditionKind.PERCENTAGE_RANGE]: [operator: NumericOperator, percentage: number];
    [ConditionKind.NUMERIC_RANGE]: [operator: NumericOperator, nmbr: number];
    [ConditionKind.MATCH_STRING]: string;
    [ConditionKind.MATCH_SEMVER]: [operator: SemverOperator, version: string];
    [ConditionKind.STRING_LIST]: string[];
    [ConditionKind.POLICY_LIST]: DeviceSettingsType[];
    [ConditionKind.WIFI_OR_ETHERNET]: 'wifi' | 'ethernet';
    [ConditionKind.INPUT_SOURCE]: 'urlLauncher' | 'hdmi1' | 'hdmi2' | 'hdmi3' | 'hdmi4';
    [ConditionKind.TIMERS]: TimerSettings[];
    [ConditionKind.PROPRIETARY_TIMERS]: ProprietaryTimerSettings[];
    [ConditionKind.RESOLUTION]: ResolutionItem;
    [ConditionKind.ORIENTATION]: OrientationSettings;
    [ConditionKind.SCHEDULED_POWER_ACTIONS]: Omit<PowerActionsScheduleSettings, 'uid'>[];
};
/** one of alert condition type safe for input alert type and condition kind */
export interface AlertCondition<T extends keyof typeof ConditionType, K extends ConditionKind> {
    type: T;
    op: ConditionOpMap[K];
}
export type AlertConditionPair<T extends AlertType> = T extends AlertType.DEVICE ? AlertCondition<typeof ConditionType.INCORRECT_TIME, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.INVALID_SSL_CERTIFICATE, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.FAILED_ACTIONS, ConditionKind.OCCURRENCES_IN_TIME_RANGE_TO_PAST> | AlertCondition<typeof ConditionType.CONNECTIONS, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.MODEL, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.SERIAL_NUMBER, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.NAME, ConditionKind.MATCH_STRING> | AlertCondition<typeof ConditionType.PIN_CODE, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.MANAGEMENT_PACKAGE_VERSION, ConditionKind.MATCH_SEMVER> | AlertCondition<typeof ConditionType.FRONT_PACKAGE_VERSION, ConditionKind.MATCH_SEMVER> | AlertCondition<typeof ConditionType.FRONT_DISPLAY_VERSION, ConditionKind.MATCH_SEMVER> | AlertCondition<typeof ConditionType.FIRMWARE_TYPE, ConditionKind.MATCH_STRING> | AlertCondition<typeof ConditionType.TAG_UIDS, ConditionKind.STRING_LIST> | AlertCondition<typeof ConditionType.POLICIES, ConditionKind.POLICY_LIST> | AlertCondition<typeof ConditionType.LAST_PROVISION_AT, ConditionKind.TIME_RANGE_TO_PAST> | AlertCondition<typeof ConditionType.LAST_DEPROVISION_AT, ConditionKind.TIME_RANGE_TO_PAST> | AlertCondition<typeof ConditionType.EXTENDED_MANAGEMENT, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.ALIVE_AT, ConditionKind.TIME_RANGE_TO_PAST> | AlertCondition<typeof ConditionType.NETWORK_INTERFACES, ConditionKind.WIFI_OR_ETHERNET> | AlertCondition<typeof ConditionType.BATTERY_STATUS, ConditionKind.PERCENTAGE_RANGE> | AlertCondition<typeof ConditionType.STORAGE_STATUS, ConditionKind.PERCENTAGE_RANGE> | AlertCondition<typeof ConditionType.CURRENT_TIMEZONE, ConditionKind.MATCH_STRING> | AlertCondition<typeof ConditionType.DISPLAY_SETTING_BACKLIGHT, ConditionKind.PERCENTAGE_RANGE> | AlertCondition<typeof ConditionType.DISPLAY_SETTING_CONTRAST, ConditionKind.PERCENTAGE_RANGE> | AlertCondition<typeof ConditionType.DISPLAY_SETTING_SHARPNESS, ConditionKind.PERCENTAGE_RANGE> | AlertCondition<typeof ConditionType.DISPLAY_SETTING_MAX_TEMPERATURE, ConditionKind.NUMERIC_RANGE> | AlertCondition<typeof ConditionType.INPUT_SOURCE, ConditionKind.INPUT_SOURCE> | AlertCondition<typeof ConditionType.VOLUME, ConditionKind.PERCENTAGE_RANGE> | AlertCondition<typeof ConditionType.BRIGHTNESS, ConditionKind.PERCENTAGE_RANGE> | AlertCondition<typeof ConditionType.TIMERS, ConditionKind.TIMERS> | AlertCondition<typeof ConditionType.PROPRIETARY_TIMERS, ConditionKind.PROPRIETARY_TIMERS> | AlertCondition<typeof ConditionType.RESOLUTION, ConditionKind.RESOLUTION> | AlertCondition<typeof ConditionType.ORIENTATION, ConditionKind.ORIENTATION> | AlertCondition<typeof ConditionType.REMOTE_CONTROL, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.APPLICATION_VERSION, ConditionKind.MATCH_SEMVER> | AlertCondition<typeof ConditionType.FIRMWARE_VERSION, ConditionKind.MATCH_STRING> | AlertCondition<typeof ConditionType.DEBUG, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POWER_ACTIONS_SCHEDULE, ConditionKind.SCHEDULED_POWER_ACTIONS> | AlertCondition<typeof ConditionType.TEMPERATURE, ConditionKind.NUMERIC_RANGE> | AlertCondition<typeof ConditionType.INSTALLED_PACKAGE, ConditionKind.MATCH_STRING> | AlertCondition<typeof ConditionType.SCREENSHOT, ConditionKind.OCCURRENCES_IN_TIME_RANGE_TO_PAST> | AlertCondition<typeof ConditionType.FEATURE_TESTS, ConditionKind.BOOLEAN> : never | T extends AlertType.POLICY ? AlertCondition<typeof ConditionType.POLICY_VIOLATION_VOLUME, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_BRIGHTNESS, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_TIMERS, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_PROPRIETARY_TIMERS, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_RESOLUTION, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_ORIENTATION, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_REMOTE_CONTROL, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_APPLICATION_VERSION, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_FIRMWARE_VERSION, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_DEBUG, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_DATETIME, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_POWER_ACTIONS_SCHEDULE, ConditionKind.BOOLEAN> | AlertCondition<typeof ConditionType.POLICY_VIOLATION_TEMPERATURE, ConditionKind.BOOLEAN> : never | T extends AlertType.APPLET ? AlertCondition<typeof ConditionType.APPLET_COMMAND, ConditionKind.STRING_OCCURRENCES_IN_TIME_RANGE_TO_PAST> : never;
/**
 * Set of currently implemented conditions union comparison.
 * The pseudo code to explain how the math is done is following:
 * => ALL.every(cond => match(cond)) && AND_ANY_OF.some(cond => match(cond))
 */
export type AlertConditions<T extends AlertType> = {
    ALL: AlertConditionPair<T>[];
    AND_ANY_OF: AlertConditionPair<T>[];
};
