// @ts-nocheck
const { fetch, Headers, Request, Response } = require('../src/Isomorphic/fetch');
const FormData = require('form-data');

// This polyfill is used for running tests

const formDataAppend = FormData.prototype.append;
FormData.prototype.append = function (name, value, options) {
	// The FormData doesn't support Blob as value argument out of box. So here we need to convert it to Buffer.
	if (typeof value === 'object' && value.constructor.name === 'Blob') {
		// node-fetch (isomorphic-fetch) returns a Blob-like object
		const bufferSymbol = Object.getOwnPropertySymbols(value)[1];
		value = value[bufferSymbol];
	}
	return formDataAppend.call(this, name, value, options);
};

global.fetch = fetch;
global.Headers = Headers;
global.Request = Request;
global.Response = Response;
global.FormData = FormData;
