declare namespace Chrome {
	export class ChromePlugin {
		public device: {
			uid: string;
		};
		display: {
			powerOn(): void;
			powerOff(): void;
		};
		system: {
			reboot(): void;
		};
		app: {
			restart(): void;
			makeFullscreen(): void;
		};
		asyncLocalStorage: {
			clear(): Promise<void>;
			getItem(key: string): Promise<string | null>;
			removeItem(key: string): Promise<void>;
			setItem(key: string, data: string): Promise<void>;
			getStorageInfo(): Promise<{ totalSizeBytes: number; availableBytes: number; usedBytes: number }>;
		};
		chrome: any;
	}
}
