"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextDecoder = void 0;
class TextDecoder {
    constructor(label, options) {
        var _a, _b, _c;
        console.warn('Using incomplete TextDecoder polyfill, this may cause non-standard behaviour.');
        this.encoding = (_a = label === null || label === void 0 ? void 0 : label.toLocaleLowerCase()) !== null && _a !== void 0 ? _a : 'utf-8';
        this.fatal = (_b = options === null || options === void 0 ? void 0 : options.fatal) !== null && _b !== void 0 ? _b : false;
        this.ignoreBOM = (_c = options === null || options === void 0 ? void 0 : options.ignoreBOM) !== null && _c !== void 0 ? _c : false;
    }
    decode(input, options) {
        if (options === null || options === void 0 ? void 0 : options.stream) {
            throw new Error('The stream option is not supported');
        }
        if (input === undefined) {
            return '';
        }
        if ('buffer' in input) {
            return Buffer.from(input.buffer, input.byteOffset, input.byteLength).toString(this.encoding);
        }
        return Buffer.from(input).toString(this.encoding);
    }
}
exports.TextDecoder = TextDecoder;
//# sourceMappingURL=TextDecoder.js.map