"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
var VideoState;
(function (VideoState) {
    VideoState[VideoState["IDLE"] = 0] = "IDLE";
    VideoState[VideoState["PREPARED"] = 1] = "PREPARED";
    VideoState[VideoState["PLAYING"] = 2] = "PLAYING";
})(VideoState || (VideoState = {}));
/**
 * Wrapper that enables video instance to have state
 */
class VideoWithState {
    constructor(video) {
        this.video = video;
        this.state = VideoState.IDLE;
        this.args = null;
        this.resolveOnceIdleCallbacks = [];
    }
    prepare(uri, x, y, width, height, options) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.video.prepare(uri, x, y, width, height, options);
            this.state = VideoState.PREPARED;
            this.args = { uri, x, y, width, height };
        });
    }
    play() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.video.play();
            this.state = VideoState.PLAYING;
        });
    }
    pause() {
        return this.video.pause();
    }
    resume() {
        return this.video.resume();
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.video.stop();
            this.state = VideoState.IDLE;
            this.args = null;
            this.resolveWaitUntilIdlePromises();
        });
    }
    waitUntilIdle() {
        return new Promise((resolve) => {
            this.resolveOnceIdleCallbacks.push(resolve);
        });
    }
    addEventListener(eventName, listener) {
        this.video.addEventListener(eventName, listener);
    }
    removeAllEventListeners() {
        this.video.removeAllEventListeners();
    }
    isIdle() {
        return this.state === VideoState.IDLE;
    }
    isPrepared() {
        return this.state === VideoState.PREPARED;
    }
    getArguments() {
        return this.args;
    }
    getDuration() {
        return this.video.getDuration();
    }
    resolveWaitUntilIdlePromises() {
        for (let i = 0; i < this.resolveOnceIdleCallbacks.length; i++) {
            this.resolveOnceIdleCallbacks[i]();
        }
        this.resolveOnceIdleCallbacks = [];
    }
}
exports.default = VideoWithState;
//# sourceMappingURL=VideoWithState.js.map