import { IPrepareOptions } from './IVideoPlayer';
import IVideo from './IVideo';
import { VideoEventType } from './IVideoEvent';
interface IVideoArguments {
    uri: string;
    x: number;
    y: number;
    width: number;
    height: number;
}
/**
 * Wrapper that enables video instance to have state
 */
export default class VideoWithState<TOptions extends IPrepareOptions> implements IVideo<TOptions> {
    private video;
    private state;
    private args;
    private resolveOnceIdleCallbacks;
    constructor(video: IVideo);
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: TOptions): Promise<void>;
    play(): Promise<void>;
    pause(): Promise<void>;
    resume(): Promise<void>;
    stop(): Promise<void>;
    waitUntilIdle(): Promise<void>;
    addEventListener(eventName: VideoEventType, listener: () => void): void;
    removeAllEventListeners(): void;
    isIdle(): boolean;
    isPrepared(): boolean;
    getArguments(): IVideoArguments | null;
    getDuration(): number;
    private resolveWaitUntilIdlePromises;
}
export {};
