"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class VideoOptions {
    constructor() {
        this.videoOptions = {};
    }
    getOptions(uri, x, y, width, height) {
        const optionsKey = this.getKeyForProperties(uri, x, y, width, height);
        return this.hasOptions(uri, x, y, width, height) ? this.videoOptions[optionsKey] : undefined;
    }
    setOptions(uri, x, y, width, height, options) {
        const optionsKey = this.getKeyForProperties(uri, x, y, width, height);
        this.videoOptions[optionsKey] = options;
    }
    clearOptions(uri, x, y, width, height) {
        const optionsKey = this.getKeyForProperties(uri, x, y, width, height);
        if (this.hasOptions(uri, x, y, width, height)) {
            delete this.videoOptions[optionsKey];
        }
    }
    hasOptions(uri, x, y, width, height) {
        var _a;
        const optionsKey = this.getKeyForProperties(uri, x, y, width, height);
        return (_a = this.videoOptions) === null || _a === void 0 ? void 0 : _a.hasOwnProperty(optionsKey);
    }
    getKeyForProperties(uri, x, y, width, height) {
        return `${uri}_${x}_${y}_${width}_${height}`;
    }
}
exports.default = VideoOptions;
//# sourceMappingURL=VideoOptions.js.map