"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lockedDecorator_1 = require("../Lock/lockedDecorator");
const events_1 = require("events");
const videoErrors_1 = require("../NativeDevice/Error/videoErrors");
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const VideoWithState_1 = __importDefault(require("./VideoWithState"));
const VideoOptions_1 = __importDefault(require("./VideoOptions"));
const LOCK_KEY = 'ProprietaryVideoPlayer.video';
const DEBUG_NAMESPACE = '@signageos/front-display:Video:ProprietaryVideoPlayer';
/**
 * Generic video player
 *
 * Since the state management of videos is the same on almost all the platforms,
 * it makes sense to have this class that implements the state management but doesn't care about the video implemention itself.
 * This class can be used directly or it can be wrapped in another class via composition that would extend it's capabilities.
 */
class ProprietaryVideoPlayer {
    constructor(videos) {
        this.videos = videos.map((video) => new VideoWithState_1.default(video));
        this.videoOptions = new VideoOptions_1.default();
    }
    getMaxVideoCount() {
        return this.videos.length;
    }
    prepare(uri, x, y, width, height, options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof options === 'object') {
                this.videoOptions.setOptions(uri, x, y, width, height, options);
            }
            yield this.prepareVideoIfNotPrepared(uri, x, y, width, height);
        });
    }
    play(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                return yield this.playVideo(uri, x, y, width, height);
            }
            catch (error) {
                if (error instanceof videoErrors_1.NoMoreAvailableVideosError) {
                    return this.playVideoOnceAvailable(uri, x, y, width, height);
                }
                else {
                    throw error;
                }
            }
        });
    }
    stop(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            let playingVideo;
            try {
                playingVideo = this.getVideoByArgumentsOrThrowException(uri, x, y, width, height);
            }
            catch (error) {
                console.warn("Attempt to stop video that's not playing");
                return;
            }
            yield playingVideo.stop();
            this.videoOptions.clearOptions(uri, x, y, width, height);
            playingVideo.removeAllEventListeners();
        });
    }
    pause(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            const playingVideo = this.getVideoByArgumentsOrThrowException(uri, x, y, width, height);
            yield playingVideo.pause();
        });
    }
    resume(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            const playingVideo = this.getVideoByArgumentsOrThrowException(uri, x, y, width, height);
            yield playingVideo.resume();
        });
    }
    clearAll() {
        return __awaiter(this, void 0, void 0, function* () {
            yield Promise.all(this.videos.map((video) => __awaiter(this, void 0, void 0, function* () {
                try {
                    yield video.stop();
                    const args = video.getArguments();
                    if (args) {
                        this.videoOptions.clearOptions(args === null || args === void 0 ? void 0 : args.uri, args === null || args === void 0 ? void 0 : args.x, args === null || args === void 0 ? void 0 : args.y, args === null || args === void 0 ? void 0 : args.width, args === null || args === void 0 ? void 0 : args.height);
                    }
                }
                catch (error) {
                    console.warn('failed to clear video', error);
                }
            })));
        });
    }
    getDuration(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            const video = this.getIdleVideoOrThrowException();
            try {
                yield this.prepareVideo(video, uri, x, y, width, height);
                const duration = video.getDuration();
                return duration;
            }
            finally {
                yield video.stop();
            }
        });
    }
    playVideo(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            const video = yield this.prepareVideoIfNotPrepared(uri, x, y, width, height);
            yield video.play();
            return this.createVideoEventEmitter(video);
        });
    }
    prepareVideoIfNotPrepared(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            let video;
            try {
                video = this.getVideoByArgumentsOrThrowException(uri, x, y, width, height);
            }
            catch (error) {
                video = this.getIdleVideoOrThrowException();
                yield this.prepareVideo(video, uri, x, y, width, height);
            }
            return video;
        });
    }
    prepareVideo(video, uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            const options = this.videoOptions.getOptions(uri, x, y, width, height);
            yield video.prepare(uri, x, y, width, height, options);
            return video;
        });
    }
    playVideoOnceAvailable(uri, x, y, width, height) {
        const videoEventEmitter = new events_1.EventEmitter();
        this.waitUntilSomeVideoBecomesIdle().then(() => __awaiter(this, void 0, void 0, function* () {
            const video = yield this.play(uri, x, y, width, height);
            video.addListener('playing', (event) => videoEventEmitter.emit('playing', event));
            video.addListener('ended', (event) => videoEventEmitter.emit('ended', event));
            video.addListener('error', (event) => videoEventEmitter.emit('error', event));
            video.addListener('stopped', (event) => videoEventEmitter.emit('stopped', event));
        }));
        return videoEventEmitter;
    }
    waitUntilSomeVideoBecomesIdle() {
        return Promise.race(this.videos.map((video) => video.waitUntilIdle()));
    }
    getIdleVideoOrThrowException() {
        for (let video of this.videos) {
            if (video.isIdle()) {
                return video;
            }
        }
        // if no idle videos available, get a prepared video instead
        for (let video of this.videos) {
            if (video.isPrepared()) {
                return video;
            }
        }
        throw new videoErrors_1.NoMoreAvailableVideosError();
    }
    getVideoByArgumentsOrThrowException(uri, x, y, width, height) {
        for (let video of this.videos) {
            const videoArguments = video.getArguments();
            if (videoArguments &&
                videoArguments.uri === uri &&
                videoArguments.x === x &&
                videoArguments.y === y &&
                videoArguments.width === width &&
                videoArguments.height === height) {
                return video;
            }
        }
        throw new Error('Video with arguments ' + JSON.stringify({ uri, x, y, width, height }) + ' not found');
    }
    createVideoEventEmitter(video) {
        const videoEventEmitter = new events_1.EventEmitter();
        const videoEvent = {
            srcArguments: video.getArguments(),
        };
        video.addEventListener('playing', () => {
            videoEventEmitter.emit('playing', Object.assign({ type: 'playing' }, videoEvent));
        });
        video.addEventListener('ended', () => {
            videoEventEmitter.emit('ended', Object.assign({ type: 'ended' }, videoEvent));
        });
        video.addEventListener('error', () => {
            videoEventEmitter.emit('error', Object.assign({ type: 'error' }, videoEvent));
        });
        video.addEventListener('stopped', () => {
            videoEventEmitter.emit('stopped', Object.assign({ type: 'stopped' }, videoEvent));
        });
        return videoEventEmitter;
    }
}
exports.default = ProprietaryVideoPlayer;
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number, Object]),
    __metadata("design:returntype", Promise)
], ProprietaryVideoPlayer.prototype, "prepare", null);
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], ProprietaryVideoPlayer.prototype, "play", null);
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], ProprietaryVideoPlayer.prototype, "stop", null);
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], ProprietaryVideoPlayer.prototype, "pause", null);
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], ProprietaryVideoPlayer.prototype, "resume", null);
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProprietaryVideoPlayer.prototype, "clearAll", null);
__decorate([
    (0, lockedDecorator_1.locked)(LOCK_KEY),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], ProprietaryVideoPlayer.prototype, "getDuration", null);
//# sourceMappingURL=ProprietaryVideoPlayer.js.map