import IVideoPlayer, { IPrepareOptions } from './IVideoPlayer';
import IVideo from './IVideo';
import IVideoEventEmitter from './IVideoEventEmitter';
/**
 * Generic video player
 *
 * Since the state management of videos is the same on almost all the platforms,
 * it makes sense to have this class that implements the state management but doesn't care about the video implemention itself.
 * This class can be used directly or it can be wrapped in another class via composition that would extend it's capabilities.
 */
export default class ProprietaryVideoPlayer<TOptions extends IPrepareOptions = IPrepareOptions> implements IVideoPlayer<TOptions> {
    private videos;
    private videoOptions;
    constructor(videos: IVideo[]);
    getMaxVideoCount(): number;
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: TOptions): Promise<void>;
    play(uri: string, x: number, y: number, width: number, height: number): Promise<IVideoEventEmitter>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    pause(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    resume(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    clearAll(): Promise<void>;
    getDuration(uri: string, x: number, y: number, width: number, height: number): Promise<number>;
    private playVideo;
    private prepareVideoIfNotPrepared;
    private prepareVideo;
    private playVideoOnceAvailable;
    private waitUntilSomeVideoBecomesIdle;
    private getIdleVideoOrThrowException;
    private getVideoByArgumentsOrThrowException;
    private createVideoEventEmitter;
}
