import IVideoEventEmitter from './IVideoEventEmitter';
export interface IPrepareOptions {
    '4k'?: boolean;
    background?: boolean;
    volume?: number;
}
interface IVideoPlayer<TOptions extends IPrepareOptions = IPrepareOptions> {
    getMaxVideoCount(): number | null;
    play(uri: string, x: number, y: number, width: number, height: number): Promise<IVideoEventEmitter>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    pause(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    resume(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: TOptions): Promise<void>;
    /** Returns duration of video in milliseconds (prepares video if not prepared), throw error if not prepared or not supported */
    getDuration(uri: string, x: number, y: number, width: number, height: number, options?: TOptions): Promise<number>;
    clearAll(): Promise<void>;
}
export default IVideoPlayer;
