import IVideoPlayer, { IPrepareOptions } from './IVideoPlayer';
import IVideoEventEmitter from './IVideoEventEmitter';
export default class HTMLVideoPlayer implements IVideoPlayer {
    private getSystemVolume?;
    private videos;
    private videoPlayer;
    constructor(maxAllowedVideos: number, window: Window, foregroundWrapperElement?: HTMLElement, backgroundWrapperElement?: HTMLElement, getSystemVolume?: (() => Promise<number>) | undefined);
    getMaxVideoCount(): number | null;
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: IPrepareOptions): Promise<void>;
    play(uri: string, x: number, y: number, width: number, height: number): Promise<IVideoEventEmitter>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    pause(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    resume(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    clearAll(): Promise<void>;
    setVolume(volume: number): void;
    getDuration(uri: string, x: number, y: number, width: number, height: number): Promise<number>;
    private createVideos;
}
