"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.vpnSaga = exports.setDeviceVPN = void 0;
const Responsibility_1 = __importDefault(require("../Feature/Responsibility"));
const ManagementCapability_1 = __importDefault(require("../NativeDevice/Management/ManagementCapability"));
const effects_1 = require("redux-saga/effects");
const socketActionCreator_1 = require("../Socket/socketActionCreator");
const deviceVPNActions_1 = require("@signageos/actions/dist/Device/VPN/deviceVPNActions");
function* setDeviceVPN(getNativeDriver, action) {
    const nativeDriver = getNativeDriver();
    try {
        if (action.enabled) {
            yield nativeDriver.vpn.connect();
        }
        else {
            yield nativeDriver.vpn.disconnect();
        }
        yield (0, effects_1.put)({
            type: deviceVPNActions_1.SetVPNSucceed,
            uid: action.uid,
        });
    }
    catch (error) {
        yield (0, effects_1.put)({
            type: deviceVPNActions_1.SetVPNFailed,
            uid: action.uid,
        });
    }
}
exports.setDeviceVPN = setDeviceVPN;
function* vpnSaga(getNativeDriver, responsibilities) {
    if (!responsibilities.has(Responsibility_1.default.VPN)) {
        return;
    }
    const nativeDriver = getNativeDriver();
    const supportPRenabled = yield (0, effects_1.call)([nativeDriver, 'managementSupports'], ManagementCapability_1.default.VPN);
    if (supportPRenabled) {
        yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(deviceVPNActions_1.SetDeviceConnectionToVPN, setDeviceVPN, getNativeDriver);
        yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(deviceVPNActions_1.PushVPNConfig, function* (action) {
            try {
                yield nativeDriver.vpn.saveConfig(action.config);
                yield (0, effects_1.put)({
                    type: deviceVPNActions_1.SetVPNSucceed,
                    uid: action.uid,
                });
            }
            catch (error) {
                yield (0, effects_1.put)({
                    type: deviceVPNActions_1.SetVPNFailed,
                    uid: action.uid,
                });
            }
        });
    }
}
exports.vpnSaga = vpnSaga;
//# sourceMappingURL=vpnSaga.js.map