"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotSupportedProprietaryTimerResolver = exports.createProprietaryTimerManagerForFront = exports.createProprietaryTimerManagerForManagement = void 0;
const DisplayPowerTimerResolver_1 = __importDefault(require("./DisplayPowerTimerResolver"));
const ProprietaryTimerResolver_1 = __importDefault(require("./ProprietaryTimerResolver"));
const Responsibility_1 = __importDefault(require("../Feature/Responsibility"));
const createProprietaryTimerManagerForManagement = (responsibilities, proprietaryTimerStorage, displayIsPowerOn) => {
    if (responsibilities.has(Responsibility_1.default.TIMERS)) {
        const storage = proprietaryTimerStorage;
        const proprietaryTimerResolver = new ProprietaryTimerResolver_1.default(storage);
        return new DisplayPowerTimerResolver_1.default(displayIsPowerOn, proprietaryTimerResolver, 30 * 1e3, storage, () => new Date());
    }
    else {
        return exports.NotSupportedProprietaryTimerResolver;
    }
};
exports.createProprietaryTimerManagerForManagement = createProprietaryTimerManagerForManagement;
const createProprietaryTimerManagerForFront = (responsibilities, proprietaryTimerStorage) => {
    if (responsibilities.has(Responsibility_1.default.TIMERS)) {
        return new ProprietaryTimerResolver_1.default(proprietaryTimerStorage);
    }
    else {
        return exports.NotSupportedProprietaryTimerResolver;
    }
};
exports.createProprietaryTimerManagerForFront = createProprietaryTimerManagerForFront;
exports.NotSupportedProprietaryTimerResolver = {
    on(_event, _listener) {
        throw new Error('not supported');
    },
};
//# sourceMappingURL=timerResolverFactory.js.map