"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolymorphicSynchronizer = void 0;
const events_1 = require("events");
const debug_1 = __importDefault(require("debug"));
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const lockedDecorator_1 = require("@signageos/lib/es6/Lock/lockedDecorator");
const ISynchronizer_1 = require("../ISynchronizer");
const DEBUG_NAMESPACE = '@signageos/front-display:Synchronization:PolymorphicSynchronizer';
const logDebug = (0, debug_1.default)(DEBUG_NAMESPACE);
/**
 * Allows to select from multiple synchronizer implementations at runtime.
 *
 * The particular implementation is selected by the connect() method.
 * Once it's connected, all the methods will adhere to that implementation.
 * Only one of the implementations should be used at a time.
 * Call close() to stop using the current implementation.
 * After calling close(), the connect() method can be used to select a different implementation.
 */
class PolymorphicSynchronizer {
    /**
     * @param synchronizers A map of synchronizer implementations. The key is the type of the synchronizer.
     *                      The first synchronizer in the map will be used as the default synchronizer.
     */
    constructor(synchronizers) {
        this.synchronizers = synchronizers;
        this.emitter = new events_1.EventEmitter();
        this.currentType = null;
        if (this.synchronizers.size === 0) {
            throw new Error('No synchronizers provided');
        }
        this.onGroupStatus = this.onGroupStatus.bind(this);
        this.onGroupLeft = this.onGroupLeft.bind(this);
        this.onBroadcastedValue = this.onBroadcastedValue.bind(this);
        this.onClosed = this.onClosed.bind(this);
    }
    /**
     * Selects the synchronizer implementation to use and makes it connect to the sync network
     * @param serverUri The URI of the sync server to connect to. If not specified, the default sync server will be used.
     *                  Only applicable to the socket synchronizer.
     * @param type The type of the synchronizer to use. If not specified, the default synchronizer will be used.
     */
    connect(serverUri, type) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.currentType) {
                throw new Error(`Already using ${type} synchronizer`);
            }
            type = type !== null && type !== void 0 ? type : this.getDefaultSynchronizerType();
            const synchronizer = this.getSynchronizerByType(type);
            yield synchronizer.connect(serverUri);
            this.listenToSynchronizerEvents(synchronizer);
            this.currentType = type;
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            const promises = [];
            for (const synchronizer of this.synchronizers.values()) {
                promises.push(this.closeSynchronizerIfConnected(synchronizer));
            }
            yield Promise.all(promises);
            this.currentType = null;
        });
    }
    isConnected() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.currentType) {
                return false;
            }
            const synchronizer = this.getSynchronizerByType(this.currentType);
            return synchronizer.isConnected();
        });
    }
    joinGroup(args) {
        return __awaiter(this, void 0, void 0, function* () {
            const synchronizer = this.getCurrentSynchronizer();
            yield synchronizer.joinGroup(args);
        });
    }
    leaveGroup(groupName) {
        return __awaiter(this, void 0, void 0, function* () {
            const synchronizer = this.getCurrentSynchronizer();
            yield synchronizer.leaveGroup(groupName);
        });
    }
    getDeviceIdentification(groupName) {
        return __awaiter(this, void 0, void 0, function* () {
            const synchronizer = this.getCurrentSynchronizer();
            return yield synchronizer.getDeviceIdentification(groupName);
        });
    }
    wait(args) {
        return __awaiter(this, void 0, void 0, function* () {
            const synchronizer = this.getCurrentSynchronizer();
            return synchronizer.wait(args);
        });
    }
    cancelWait(groupName) {
        return __awaiter(this, void 0, void 0, function* () {
            const synchronizer = this.getCurrentSynchronizer();
            yield synchronizer.cancelWait(groupName);
        });
    }
    broadcastValue(args) {
        return __awaiter(this, void 0, void 0, function* () {
            const synchronizer = this.getCurrentSynchronizer();
            yield synchronizer.broadcastValue(args);
        });
    }
    isMaster(groupName) {
        return __awaiter(this, void 0, void 0, function* () {
            const synchronizer = this.getCurrentSynchronizer();
            return yield synchronizer.isMaster(groupName);
        });
    }
    addListener(event, listener) {
        this.emitter.addListener(event, listener);
    }
    removeListener(event, listener) {
        this.emitter.removeListener(event, listener);
    }
    listenToSynchronizerEvents(synchronizer) {
        synchronizer.addListener(ISynchronizer_1.SynchronizerEvent.GroupStatus, this.onGroupStatus);
        synchronizer.addListener(ISynchronizer_1.SynchronizerEvent.GroupLeft, this.onGroupLeft);
        synchronizer.addListener(ISynchronizer_1.SynchronizerEvent.BroadcastedValue, this.onBroadcastedValue);
        synchronizer.addListener(ISynchronizer_1.SynchronizerEvent.Closed, this.onClosed);
    }
    stopListeningToSynchronizerEvents(synchronizer) {
        synchronizer.removeListener(ISynchronizer_1.SynchronizerEvent.GroupStatus, this.onGroupStatus);
        synchronizer.removeListener(ISynchronizer_1.SynchronizerEvent.GroupLeft, this.onGroupLeft);
        synchronizer.removeListener(ISynchronizer_1.SynchronizerEvent.BroadcastedValue, this.onBroadcastedValue);
        synchronizer.removeListener(ISynchronizer_1.SynchronizerEvent.Closed, this.onClosed);
    }
    onGroupStatus(deviceStatus) {
        logDebug('got group status event', deviceStatus);
        this.emitter.emit(ISynchronizer_1.SynchronizerEvent.GroupStatus, deviceStatus);
    }
    onGroupLeft(groupName) {
        logDebug('got group left event', groupName);
        this.emitter.emit(ISynchronizer_1.SynchronizerEvent.GroupLeft, groupName);
    }
    onBroadcastedValue(broadcastedValue) {
        logDebug('got broadcasted value event', broadcastedValue);
        this.emitter.emit(ISynchronizer_1.SynchronizerEvent.BroadcastedValue, broadcastedValue);
    }
    onClosed(error) {
        return __awaiter(this, void 0, void 0, function* () {
            logDebug('got closed event', error);
            this.emitter.emit(ISynchronizer_1.SynchronizerEvent.Closed, error);
            try {
                yield this.close();
            }
            catch (e) {
                console.error('Failed to close synchronizer', e);
            }
        });
    }
    getDefaultSynchronizerType() {
        return this.synchronizers.keys().next().value;
    }
    getSynchronizerByType(type) {
        const synchronizer = this.synchronizers.get(type);
        if (!synchronizer) {
            throw new Error(`Unknown synchronizer type: ${type}`);
        }
        return synchronizer;
    }
    getCurrentSynchronizer() {
        if (!this.currentType) {
            throw new Error('Not connected');
        }
        return this.getSynchronizerByType(this.currentType);
    }
    closeSynchronizerIfConnected(synchronizer) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                if (yield synchronizer.isConnected()) {
                    yield synchronizer.close();
                }
            }
            finally {
                this.stopListeningToSynchronizerEvents(synchronizer);
            }
        });
    }
}
exports.PolymorphicSynchronizer = PolymorphicSynchronizer;
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    (0, lockedDecorator_1.locked)('sync', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "connect", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    (0, lockedDecorator_1.locked)('sync', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "close", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "isConnected", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    (0, lockedDecorator_1.locked)('sync', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "joinGroup", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    (0, lockedDecorator_1.locked)('sync', { scope: 'instance' }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "leaveGroup", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "wait", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "cancelWait", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "broadcastValue", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PolymorphicSynchronizer.prototype, "isMaster", null);
//# sourceMappingURL=PolymorphicSynchronizer.js.map