"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createP2PSynchronizer = exports.TCP_SYNC_PORT = exports.UDP_SYNC_PORT = void 0;
const P2PSynchronizer_1 = require("./P2PSynchronizer");
const PeerDiscoveryService_1 = require("../../PeerNetwork/PeerDiscoveryService/PeerDiscoveryService");
const MessageTcpSocket_1 = require("../../PeerNetwork/Socket/Tcp/MessageTcpSocket");
const MessageUdpSocket_1 = require("../../PeerNetwork/Socket/Udp/MessageUdpSocket");
const PeerNetwork_1 = require("../../PeerNetwork/PeerNetwork");
const OrderedTcpSocket_1 = require("../../PeerNetwork/Socket/Tcp/OrderedTcpSocket");
exports.UDP_SYNC_PORT = 60537;
exports.TCP_SYNC_PORT = 60538;
/**
 * Convenience factory to create and instance of P2PSynchronizer
 *
 * It uses PeerDiscoveryService and a default or custom socket factory.
 * By default it uses UdpSocket but a custom socket factory can be provided.
 */
function createP2PSynchronizer({ udpPort = exports.UDP_SYNC_PORT, tcpPort = exports.TCP_SYNC_PORT, getDeviceUid, getLocalAddress, serializer, udpSocketFactory, tcpSocketFactory, }) {
    return __awaiter(this, void 0, void 0, function* () {
        const id = yield getDeviceUid();
        const udpSocketFactoryWithoutPort = getUdpSocketFactoryWithoutPort(udpSocketFactory, serializer, udpPort);
        const tcpSocketFactoryWithoutPort = getTcpSocketFactoryWithoutPort(tcpSocketFactory, serializer, tcpPort);
        const getNetworkInfo = getNetworkInfoProvider(tcpPort, getLocalAddress);
        const peerDiscoveryService = new PeerDiscoveryService_1.PeerDiscoveryService(id, udpSocketFactoryWithoutPort, getNetworkInfo);
        const peerNetwork = new PeerNetwork_1.PeerNetwork(peerDiscoveryService, tcpSocketFactoryWithoutPort);
        return new P2PSynchronizer_1.P2PSynchronizer(peerNetwork);
    });
}
exports.createP2PSynchronizer = createP2PSynchronizer;
function getNetworkInfoProvider(port, getLocalAddress) {
    return () => __awaiter(this, void 0, void 0, function* () {
        var _a;
        const address = (_a = (yield getLocalAddress())) !== null && _a !== void 0 ? _a : '0.0.0.0';
        return {
            address,
            port,
        };
    });
}
function getTcpSocketFactoryWithoutPort(socketFactory, serializer, port) {
    return () => __awaiter(this, void 0, void 0, function* () {
        const socket = yield socketFactory(port);
        const orderedSocket = new OrderedTcpSocket_1.OrderedTcpSocket(socket);
        return new MessageTcpSocket_1.MessageTcpSocket(orderedSocket, serializer);
    });
}
function getUdpSocketFactoryWithoutPort(socketFactory, serializer, port) {
    return () => __awaiter(this, void 0, void 0, function* () {
        const socket = yield socketFactory(port);
        return new MessageUdpSocket_1.MessageUdpSocket(socket, serializer);
    });
}
//# sourceMappingURL=p2pSynchronizerFactory.js.map