import { P2PSynchronizer } from './P2PSynchronizer';
import { ITcpSocket } from '../../PeerNetwork/Socket/Tcp/ITcpSocket';
import { ISerializer } from '../../PeerNetwork/Serializer/serialization';
import { IUdpSocket } from '../../PeerNetwork/Socket/Udp/IUdpSocket';
export declare const UDP_SYNC_PORT = 60537;
export declare const TCP_SYNC_PORT = 60538;
export type UdpSocketFactory<TSerialized> = (port: number) => Promise<IUdpSocket<TSerialized>>;
export type TcpSocketFactory<TSerialized> = (port: number) => Promise<ITcpSocket<TSerialized>>;
/**
 * Convenience factory to create and instance of P2PSynchronizer
 *
 * It uses PeerDiscoveryService and a default or custom socket factory.
 * By default it uses UdpSocket but a custom socket factory can be provided.
 */
export declare function createP2PSynchronizer<TSerialized>({ udpPort, tcpPort, getDeviceUid, getLocalAddress, serializer, udpSocketFactory, tcpSocketFactory, }: {
    /**
     * Port for UDP communication
     * UDP communication is used for network discovery, i.e. to find other devices on the network
     */
    udpPort?: number;
    /**
     * Port for TCP communication
     * TCP communication is used for sending messages between devices
     */
    tcpPort?: number;
    getDeviceUid: () => Promise<string>;
    getLocalAddress: () => Promise<string | null>;
    serializer: ISerializer<TSerialized>;
    udpSocketFactory: UdpSocketFactory<TSerialized>;
    tcpSocketFactory: TcpSocketFactory<TSerialized>;
}): Promise<P2PSynchronizer>;
