import ISynchronizer, { BroadcastedValueArgs, BroadcastedValueCallback, ClosedCallback, GroupLeftCallback, GroupStatusCallback, JoinGroupArgs, SynchronizerEvent, WaitArgs } from '../ISynchronizer';
import { IGroup } from '../Group/IGroup';
import { IPeerNetwork } from '../../PeerNetwork/IPeerNetwork';
export interface GroupFactoryArgs {
    name: string;
    groupName: string;
    peerNetwork: IPeerNetwork;
}
export type GroupFactory = (args: GroupFactoryArgs) => IGroup;
export interface P2PSynchronizerOptions {
    /** how often should it emit device_status event with current status */
    deviceStatusInterval: number;
}
/**
 * Synchronizes devices via provided IPeerDiscoveryService
 *
 * The original purpose of this is to implement synchronization of devices in
 * local network via UDP without a need for an external synchronization server.
 */
export declare class P2PSynchronizer implements ISynchronizer {
    private peerNetwork;
    private groupFactory;
    private groups;
    private options;
    private emitter;
    constructor(peerNetwork: IPeerNetwork, options?: Partial<P2PSynchronizerOptions>, groupFactory?: GroupFactory);
    connect(_serverUri?: string | undefined): Promise<void>;
    close(): Promise<void>;
    isConnected(): Promise<boolean>;
    joinGroup({ groupName, deviceIdentification }: JoinGroupArgs): Promise<void>;
    leaveGroup(groupName: string): Promise<void>;
    getDeviceIdentification(groupName: string): Promise<string | undefined>;
    wait({ groupName, data, timeoutMs }: WaitArgs): Promise<unknown>;
    cancelWait(groupName: string): Promise<void>;
    broadcastValue({ groupName, key, value }: BroadcastedValueArgs): Promise<void>;
    isMaster(groupName: string): Promise<boolean>;
    addListener(event: SynchronizerEvent.GroupStatus, listener: GroupStatusCallback): void;
    addListener(event: SynchronizerEvent.GroupLeft, listener: GroupLeftCallback): void;
    addListener(event: SynchronizerEvent.BroadcastedValue, listener: BroadcastedValueCallback): void;
    addListener(event: SynchronizerEvent.Closed, listener: ClosedCallback): void;
    removeListener(event: SynchronizerEvent.GroupStatus, listener: GroupStatusCallback): void;
    removeListener(event: SynchronizerEvent.GroupLeft, listener: GroupLeftCallback): void;
    removeListener(event: SynchronizerEvent.BroadcastedValue, listener: BroadcastedValueCallback): void;
    removeListener(event: SynchronizerEvent.Closed, listener: ClosedCallback): void;
    private createGroup;
    private waitOrTimeout;
    private resolveWithDataAfterTimeout;
    private listenToPeerNetworkEvents;
    private handlePeerNetworkClosed;
}
