import { IWaitService } from './IWaitService';
import { IGroup } from './IGroup';
/**
 * WaitService handles synchronization of runtime with others in the network via wait interface
 */
export declare class WaitService implements IWaitService {
    private group;
    private started;
    private currentWait;
    private waitingPeers;
    private emitter;
    constructor(group: IGroup);
    sendWaitMessageAndWaitForOthers(data: unknown): Promise<unknown>;
    cancelWait(): Promise<void>;
    start(): Promise<void>;
    stop(): void;
    private handleData;
    private handleQueryMessage;
    private handleWaitMessage;
    private handleNotWaitingMessage;
    private handlePeersChanged;
    private emitEventIfAllPeersWaiting;
    private clearDeadWaitingPeers;
    private sendQueryMessage;
    private sendWaitMessage;
    private sendNotWaitingMessage;
    private waitForAllPeers;
    private countPeersLeftToWait;
    private allPeersWaiting;
    private getDataOfWaitingMaster;
    private reset;
    private logDebug;
}
