import { IPeerNetwork } from '../../PeerNetwork/IPeerNetwork';
import { DataCallback, GroupEvent, GroupMember, IGroup, MemberCallback } from './IGroup';
/**
 * Group automatically handles membership in a group for synchronization purposes.
 */
export declare class Group implements IGroup {
    private memberName;
    private groupName;
    private peerNetwork;
    private peers;
    private started;
    private joinedAt;
    private emitter;
    private sendQueryIntervalMs;
    private sendQueryInterval;
    constructor({ name, groupName, peerNetwork, sendQueryIntervalMs, }: {
        name: string;
        groupName: string;
        peerNetwork: IPeerNetwork;
        sendQueryIntervalMs?: number;
    });
    getGroupName(): string;
    getMe(): GroupMember;
    getPeers(): GroupMember[];
    getAllMembers(): GroupMember[];
    getMaster(): GroupMember;
    join(): Promise<void>;
    leave(): Promise<void>;
    sendGroupDataMessage(data: unknown): Promise<void>;
    addListener(event: GroupEvent.MemberJoined, callback: MemberCallback): void;
    addListener(event: GroupEvent.MemberLeft, callback: MemberCallback): void;
    addListener(event: GroupEvent.Data, callback: DataCallback): void;
    removeListener(event: GroupEvent.MemberJoined, callback: MemberCallback): void;
    removeListener(event: GroupEvent.MemberLeft, callback: MemberCallback): void;
    removeListener(event: GroupEvent.Data, callback: DataCallback): void;
    removeAllListeners(event?: GroupEvent | undefined): void;
    private handleMessage;
    private handleQueryMessage;
    private handleJoinGroupMessage;
    private handleLeaveGroupMessage;
    private handleGroupDataMessage;
    private handlePeersChanged;
    private findPeerById;
    private clearDeadPeers;
    /**
     * Send query messages periodically to compensate for potential network issues
     * If each peer only sends join_group and query once and someone is unable to receive it
     * at that time because of network issues, they'll never send them again and
     * there will be a partitioned group.
     * Sending query messages periodically ensures that everyone will eventually
     * receive the join_group message from everyone else, as long as the network issues get resolved.
     */
    private startSendingQueryMessages;
    private stopSendingQueryMessages;
    private sendQueryMessage;
    private sendJoinGroupMessage;
    private sendLeaveGroupMessage;
    private logDebug;
}
