"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BroadcastService = void 0;
const events_1 = require("events");
const debug_1 = __importDefault(require("debug"));
const IGroup_1 = require("./IGroup");
const IBroadcastService_1 = require("./IBroadcastService");
const debug = (0, debug_1.default)('@signageos/front-display:Synchronization:BroadcastService');
var MessageType;
(function (MessageType) {
    MessageType["BroadcastValue"] = "broadcast_value";
})(MessageType || (MessageType = {}));
function isMessage(message) {
    return typeof message === 'object' && message !== null && 'type' in message;
}
function isBroadcastValueMessage(message) {
    return isMessage(message) && message.type === MessageType.BroadcastValue;
}
/**
 * Used to broadcast values to all devices in the same network.
 *
 * It uses IGroup under the hood which provides functionality to communicate with other devices in the same group.
 */
class BroadcastService {
    constructor(group) {
        this.group = group;
        this.emitter = new events_1.EventEmitter();
        this.handleData = this.handleData.bind(this);
    }
    start() {
        this.group.addListener(IGroup_1.GroupEvent.Data, this.handleData);
    }
    stop() {
        this.group.removeListener(IGroup_1.GroupEvent.Data, this.handleData);
    }
    broadcastValue(key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            const message = {
                type: MessageType.BroadcastValue,
                key,
                value,
            };
            this.logDebug('broadcast value', JSON.stringify(message));
            this.group.sendGroupDataMessage(message);
        });
    }
    addListener(event, listener) {
        this.emitter.addListener(event, listener);
    }
    removeListener(event, listener) {
        this.emitter.removeListener(event, listener);
    }
    handleData({ from, data }) {
        this.logDebug('got data message from ' + from.id, JSON.stringify(data));
        if (isBroadcastValueMessage(data)) {
            this.handleBroadcastValueMessage(from, data);
        }
    }
    handleBroadcastValueMessage(from, message) {
        this.logDebug('got broadcast value message from ' + from.id, JSON.stringify(message));
        this.emitter.emit(IBroadcastService_1.BroadcastEvent.Value, message.key, message.value);
    }
    logDebug(...args) {
        debug(this.group.getGroupName(), ...args);
    }
}
exports.BroadcastService = BroadcastService;
//# sourceMappingURL=BroadcastService.js.map