import { IGroup } from './IGroup';
import { BroadcastEvent, IBroadcastService, ValueCallback } from './IBroadcastService';
/**
 * Used to broadcast values to all devices in the same network.
 *
 * It uses IGroup under the hood which provides functionality to communicate with other devices in the same group.
 */
export declare class BroadcastService implements IBroadcastService {
    private group;
    private emitter;
    constructor(group: IGroup);
    start(): void;
    stop(): void;
    broadcastValue(key: string, value: unknown): Promise<void>;
    addListener(event: BroadcastEvent.Value, listener: ValueCallback): void;
    removeListener(event: BroadcastEvent.Value, listener: ValueCallback): void;
    private handleData;
    private handleBroadcastValueMessage;
    private logDebug;
}
