import IStreamPlayer, { IStreamOptions, IStreamPrepareOptions, ITrackInfo, TrackType } from './IStreamPlayer';
import IStream from './IStream';
import { IVideoSrcArguments } from '../Video/IVideoSrcArguments';
declare class ReconnectStreamPlayer implements IStreamPlayer {
    private streamPlayer;
    private streamsProperties;
    constructor(streamPlayer: IStreamPlayer);
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: IStreamPrepareOptions): Promise<void>;
    play(uri: string, x: number, y: number, width: number, height: number, options?: IStreamOptions): Promise<IStream>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    pause(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    resume(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    clearAll(): Promise<void>;
    getTracks(videoId: IVideoSrcArguments): Promise<ITrackInfo[]>;
    selectTrack(videoId: IVideoSrcArguments, trackType: TrackType, groupId: string, trackIndex: number): Promise<void>;
    resetTrack(videoId: IVideoSrcArguments, trackType: TrackType, groupId?: string): Promise<void>;
    private streamConnect;
    private scheduleStreamReconnect;
    private streamReconnect;
    private getKeyForProperties;
    private getStreamProperties;
    private cancelStreamReconnectSchedule;
    private clearStreamProperties;
    private emitEvent;
}
export default ReconnectStreamPlayer;
