"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class MemoryStorage {
    get length() {
        return this.getKeys().length;
    }
    clear() {
        for (let key of this.getKeys()) {
            this.removeItem(key);
        }
    }
    getItem(key) {
        return typeof this[key] !== 'undefined' ? this[key] : null;
    }
    removeItem(key) {
        delete this[key];
    }
    setItem(key, data) {
        this[key] = '' + data;
    }
    key(index) {
        return this.getKeys()[index];
    }
    getKeys() {
        return Object.keys(this);
    }
}
exports.default = MemoryStorage;
//# sourceMappingURL=MemoryStorage.js.map