"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.healthChecking = void 0;
const socketActionCreator_1 = require("./socketActionCreator");
const effects_1 = require("redux-saga/effects");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const socketActions_1 = require("@signageos/actions/dist/Socket/socketActions");
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const socketActions_2 = require("./socketActions");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Socket:socketHealthCheckSagas');
function* healthChecking() {
    let platformUri;
    let socketDriver;
    let isSocketConnected = false;
    yield (0, socketActionCreator_1.bindAndTakeEvery)(socketActions_1.PlatformConnect, function* (action) {
        platformUri = action.platformUri;
        socketDriver = action.driver;
    });
    yield (0, effects_1.takeEvery)(socketActions_2.SocketConnected, function* () {
        debug('socket connected');
        isSocketConnected = true;
    });
    yield (0, effects_1.takeEvery)(socketActions_1.SocketDisconnected, function* () {
        debug('socket disconnected');
        isSocketConnected = false;
    });
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        const RESPONSE_TIMEOUT = 60e3;
        yield (0, wait_1.default)(60 * 1e3);
        while (true) {
            try {
                if (isSocketConnected) {
                    const checkSocketHealth = yield (0, effects_1.put)({ type: socketActions_2.CheckSocketHealth });
                    yield new Promise((resolve, reject) => {
                        const timoutHandler = setTimeout(() => reject(new Error('Action timed out')), RESPONSE_TIMEOUT);
                        checkSocketHealth.__emitter.once('delivered', () => {
                            clearTimeout(timoutHandler);
                            resolve();
                        });
                    });
                }
                else {
                    debug("don't check because socket isn't connected");
                }
            }
            catch (error) {
                debug('healthChecking failed. Try reconnect socket.', error);
                if (isSocketConnected) {
                    yield (0, effects_1.put)({
                        type: socketActions_1.PlatformConnect,
                        platformUri: platformUri,
                        driver: socketDriver,
                    });
                }
            }
            finally {
                yield (0, wait_1.default)(2 * 60 * 1e3);
            }
        }
    });
}
exports.healthChecking = healthChecking;
//# sourceMappingURL=socketHealthCheckSagas.js.map