"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shouldBeAddedToFastOfflineBuffer = exports.shouldBeSentToServer = void 0;
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
const EmitVideoEvent_1 = require("../Front/Applet/Video/EmitVideoEvent");
const socketActions_1 = require("./socketActions");
const appletActions_1 = require("@signageos/actions/dist/Applet/appletActions");
const deviceConfigurationActions_1 = require("../Device/Configuration/deviceConfigurationActions");
const appletVideoActions_1 = require("../Front/Applet/Video/appletVideoActions");
const dependenciesActions_1 = require("../DI/dependenciesActions");
const offlineActions_1 = require("../Offline/offlineActions");
const systemLogActions_1 = require("@signageos/actions/dist/SystemLog/systemLogActions");
const keyActions_1 = require("@signageos/actions/dist/Input/keyActions");
const streamActions_1 = require("../Stream/streamActions");
const motionActions_1 = require("@signageos/actions/dist/Input/motionActions");
const deviceActions_1 = require("../Front/Device/deviceActions");
const EXCLUDED_DELIVERY_TO_SERVER_ACTIONS = [
    activeAppletActions_1.AppletPing,
    socketActions_1.BindAction,
    socketActions_1.UnbindAction,
    socketActions_1.CheckSocketHealth,
    appletVideoActions_1.ActiveAppletVideoPlay,
    appletVideoActions_1.ActiveAppletVideoPrepare,
    appletVideoActions_1.ActiveAppletVideoStop,
    appletVideoActions_1.ActiveAppletVideoPause,
    appletVideoActions_1.ActiveAppletVideoResume,
    EmitVideoEvent_1.EmitVideoEvent,
    appletActions_1.UpdateActiveAppletBinary,
    appletActions_1.UpdateActiveAppletBinaryFile,
    deviceConfigurationActions_1.CheckDeviceConfiguration,
    dependenciesActions_1.UpdateDIDependency,
    dependenciesActions_1.UpdateDIContainer,
    dependenciesActions_1.RequestDIContainer,
    offlineActions_1.SaveOfflineAction,
    offlineActions_1.DeviceAlive,
    keyActions_1.HandleKeySequence,
    keyActions_1.HandleKeyUp,
    motionActions_1.HandleMotion,
    motionActions_1.HandleMotionSequence,
    streamActions_1.StreamConnected,
    streamActions_1.StreamDisconnected,
    deviceActions_1.UpdateDisplayFirmwareVersion,
];
function shouldBeSentToServer(action) {
    return !EXCLUDED_DELIVERY_TO_SERVER_ACTIONS.includes(action.type);
}
exports.shouldBeSentToServer = shouldBeSentToServer;
const EXCLUDED_FROM_FAST_OFFLINE_BUFFER = [activeAppletActions_1.ActiveAppletDispatchCommand, systemLogActions_1.SystemLog];
function shouldBeAddedToFastOfflineBuffer(action) {
    return !EXCLUDED_FROM_FAST_OFFLINE_BUFFER.includes(action.type);
}
exports.shouldBeAddedToFastOfflineBuffer = shouldBeAddedToFastOfflineBuffer;
//# sourceMappingURL=socketActionFilter.js.map