"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.takeEveryAndBindWhenPlatform = exports.bindWhenPlatform = exports.bindAndTakeEveryOnlyWhenPlatform = exports.bindAndTakeEvery = void 0;
const effects_1 = require("redux-saga/effects");
const socketActions_1 = require("./socketActions");
const deviceConfigurationActions_1 = require("../Device/Configuration/deviceConfigurationActions");
const dependencyInjection_1 = require("../DI/dependencyInjection");
const IConfig_1 = require("../Display/IConfig");
const applicationActions_1 = require("../Application/applicationActions");
const bindAndTakeEvery = (actionNames, saga, ...args) => (0, effects_1.fork)(function* () {
    yield bindActionsUntilStopped(actionNames);
    yield (0, effects_1.takeEvery)(actionNames, saga, ...args);
});
exports.bindAndTakeEvery = bindAndTakeEvery;
/**
 * This function process actions and send them FROM server only when device is platform.
 * When device is open actions aren't process and then aren't send FROM server.
 */
const bindAndTakeEveryOnlyWhenPlatform = (actionNames, saga, ...args) => (0, effects_1.fork)((0, dependencyInjection_1.withDependencies)(['subscriptionType'], function* ({ subscriptionType }) {
    if (subscriptionType === IConfig_1.SubscriptionType.platform) {
        yield (0, exports.bindAndTakeEvery)(actionNames, saga, ...args);
    }
}));
exports.bindAndTakeEveryOnlyWhenPlatform = bindAndTakeEveryOnlyWhenPlatform;
/**
 * Actions are send FROM server only when device is platform.
 * @deprecated Use withDependencies instead and all will be bound correctly
 */
const bindWhenPlatform = (actionNames) => (0, effects_1.fork)(function* () {
    while (true) {
        yield (0, effects_1.take)(deviceConfigurationActions_1.ChangeSubscriptionToPlatform);
        yield bindActions(actionNames);
        yield (0, effects_1.take)(deviceConfigurationActions_1.ChangeSubscriptionToOpen);
        yield unbindActions(actionNames);
    }
});
exports.bindWhenPlatform = bindWhenPlatform;
/**
 * This function process actions when device is platform or open.
 * Actions are send FROM server only when device is platform.
 */
const takeEveryAndBindWhenPlatform = (actionNames, saga, ...args) => (0, effects_1.fork)(function* () {
    yield (0, effects_1.takeEvery)(actionNames, saga, ...args);
    yield (0, effects_1.call)((0, dependencyInjection_1.withDependencies)(['subscriptionType'], function* ({ subscriptionType }) {
        if (subscriptionType === IConfig_1.SubscriptionType.platform) {
            yield bindActionsUntilStopped(actionNames);
        }
    }));
});
exports.takeEveryAndBindWhenPlatform = takeEveryAndBindWhenPlatform;
/**
 * Canceling the saga is behave the same as stop
 */
const bindActionsUntilStopped = (actionNames) => (0, effects_1.fork)(function* () {
    try {
        yield* bindActions(actionNames);
        yield (0, effects_1.take)(applicationActions_1.StopApplication);
    }
    finally {
        yield* unbindActions(actionNames);
    }
});
function* bindActions(actionNames) {
    actionNames = Array.isArray(actionNames) ? actionNames : [actionNames];
    for (const actionName of actionNames) {
        if (actionName !== '*') {
            yield (0, effects_1.put)({
                type: socketActions_1.BindAction,
                actionName,
            });
        }
    }
}
function* unbindActions(actionNames) {
    actionNames = Array.isArray(actionNames) ? actionNames : [actionNames];
    for (const actionName of actionNames) {
        if (actionName !== '*') {
            yield (0, effects_1.put)({
                type: socketActions_1.UnbindAction,
                actionName,
            });
        }
    }
}
//# sourceMappingURL=socketActionCreator.js.map