"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThrottledActionsChecker = void 0;
const node_cache_1 = __importDefault(require("node-cache"));
class ThrottledActionsChecker {
    constructor(actionUploader, actionLimitMap) {
        this.actionUploader = actionUploader;
        this.actionLimitMap = actionLimitMap;
        this.cache = new node_cache_1.default({
            checkperiod: 5,
            deleteOnExpire: true,
            useClones: false,
        });
    }
    addActionOrPass(action) {
        return __awaiter(this, void 0, void 0, function* () {
            const key = `${action.type}`;
            if (this.actionLimitMap[action.type]) {
                const { limit, windowSecs: ttl } = this.actionLimitMap[action.type];
                if (this.cache.has(key)) {
                    const counterObj = this.cache.get(key);
                    if (counterObj && counterObj.counter < limit) {
                        // mutable update so ttl does not refresh
                        counterObj.counter++;
                        yield this.actionUploader.addAction(action);
                    }
                }
                else {
                    this.cache.set(key, { counter: 1 }, ttl);
                    yield this.actionUploader.addAction(action);
                }
            }
        });
    }
}
exports.ThrottledActionsChecker = ThrottledActionsChecker;
//# sourceMappingURL=ThrottledActionsChecker.js.map