"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Servlet:SupervisedServletProcess');
/**
 * Servlet process wrapper that ensures that the process is always running
 *
 * If it stops, it restarts it.
 * Inspired by https://wiki.gentoo.org/wiki/OpenRC/supervise-daemon
 */
class SupervisedServletProcess {
    constructor(runProcess) {
        this.runProcess = runProcess;
        this.closed = false;
        this.eventEmitter = new events_1.EventEmitter();
        this.runAndSuperviseServletProcess();
    }
    getId() {
        return this.servletProcess.getId();
    }
    sendMessage(message) {
        this.servletProcess.sendMessage(message);
    }
    onMessage(messageListener) {
        this.eventEmitter.addListener('message', messageListener);
        return () => this.eventEmitter.removeListener('message', messageListener);
    }
    onceClosed(listener) {
        this.eventEmitter.once('closed', listener);
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            this.closed = true;
            yield this.servletProcess.stop();
            this.eventEmitter.emit('closed');
        });
    }
    runAndSuperviseServletProcess() {
        debug('starting supervised servlet process');
        this.servletProcess = this.runProcess();
        this.servletProcess.onMessage((message) => {
            debug(`servlet ${this.servletProcess.getId()} message`, message);
            this.eventEmitter.emit('message', message);
        });
        this.servletProcess.onceClosed(() => __awaiter(this, void 0, void 0, function* () {
            debug(`servlet ${this.servletProcess.getId()} process was closed`);
            if (!this.closed) {
                const TIMEOUT_BEFORE_RESTART = 1e3;
                yield (0, wait_1.default)(TIMEOUT_BEFORE_RESTART);
                this.runAndSuperviseServletProcess();
            }
        }));
    }
}
exports.default = SupervisedServletProcess;
//# sourceMappingURL=SupervisedServletProcess.js.map