import { SerialPortStream } from '@serialport/stream';
import { ISerialPort, SerialPortEvent } from '../NativeDevice/Hardware/ISerial';
export default class SerialPort implements ISerialPort {
    private serialPort;
    private eventEmitter;
    constructor(serialPort: SerialPortStream);
    on(event: SerialPortEvent.DATA, listener: (data: Uint8Array) => void): void;
    on(event: SerialPortEvent.CLOSE, listener: () => void): void;
    removeListener(event: SerialPortEvent.DATA, listener: (data: Uint8Array) => void): void;
    removeListener(event: SerialPortEvent.CLOSE, listener: () => void): void;
    removeAllListeners(event?: SerialPortEvent): void;
    write(data: string | number[] | Uint8Array): Promise<void>;
    close(): Promise<void>;
    private drainSocket;
    private closeSocket;
    private bindAndConvertDataEvents;
}
