"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSerialPortOptions = void 0;
const stream_1 = require("@serialport/stream");
const bindings_cpp_1 = require("@serialport/bindings-cpp");
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const ISerial_1 = require("../NativeDevice/Hardware/ISerial");
const lockedDecorator_1 = require("../Lock/lockedDecorator");
const SerialPort_1 = __importDefault(require("./SerialPort"));
const lodash_1 = require("lodash");
const DEBUG_NAMESPACE = '@signageos/front-display:Serial:Serial';
class Serial {
    /**
     * @param binding Defaults to platform bindings. Override for testing.
     */
    constructor(binding = (0, bindings_cpp_1.autoDetect)()) {
        this.openPorts = [];
        this.binding = binding;
    }
    openPort(options) {
        return __awaiter(this, void 0, void 0, function* () {
            const hardwareSerialPort = yield this.createAndOpenSerialPort(options);
            const serialPort = new SerialPort_1.default(hardwareSerialPort);
            this.openPorts.push(serialPort);
            serialPort.on(ISerial_1.SerialPortEvent.CLOSE, () => {
                this.openPorts = this.openPorts.filter((openPort) => openPort !== serialPort);
            });
            return serialPort;
        });
    }
    closeAll() {
        return __awaiter(this, void 0, void 0, function* () {
            yield Promise.all(this.openPorts.map((openPort) => openPort.close()));
            this.openPorts = [];
        });
    }
    createAndOpenSerialPort(options) {
        const path = typeof options.device !== 'undefined' ? options.device : '/dev/ttyUSB0';
        const serialPortOptions = this.prepareSerialPortOptions(path, options);
        const serialPort = new stream_1.SerialPortStream(Object.assign(Object.assign({ binding: this.binding }, serialPortOptions), { autoOpen: false }));
        return new Promise((resolve, reject) => {
            serialPort.open((error) => {
                if (error) {
                    reject(error);
                }
                else {
                    resolve(serialPort);
                }
            });
        });
    }
    prepareSerialPortOptions(path, options) {
        // > The constructor no longer has an optional baudRate
        // > (The old default of 9600 was slow and usually not what's required.).
        // > Because of this we combined the path into the options object and made it required.
        // https://serialport.io/docs/guide-upgrade#serialport-package
        const serialPortOptions = {
            path,
            baudRate: typeof options.baudRate !== 'undefined' ? options.baudRate : 9600,
        };
        if (typeof options.parity !== 'undefined') {
            serialPortOptions.parity = options.parity;
        }
        if (typeof options.databits !== 'undefined') {
            serialPortOptions.dataBits = options.databits;
        }
        if (typeof options.stopbits !== 'undefined') {
            serialPortOptions.stopBits = options.stopbits;
        }
        if (typeof options.rtscts !== 'undefined') {
            serialPortOptions.rtscts = options.rtscts;
        }
        return serialPortOptions;
    }
}
exports.default = Serial;
__decorate([
    (0, lockedDecorator_1.locked)('serial'),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], Serial.prototype, "openPort", null);
__decorate([
    (0, lockedDecorator_1.locked)('serial'),
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], Serial.prototype, "closeAll", null);
// Check the passed options and throw an error if some of them are not supported
function validateSerialPortOptions(options, supportedOptions) {
    // baudRate is required to open a serial port - throw an error if it is missing
    if (!options.baudRate) {
        throw new Error('The baudRate option is required');
    }
    // throw an error in case that some of the passed options are not supported on the particular platform
    const unsupportedOptions = (0, lodash_1.difference)(Object.keys(options), supportedOptions);
    if (unsupportedOptions.length > 0) {
        throw new Error(`The following options are not supported in the SerialPort implementation: ${unsupportedOptions.join(', ')}`);
    }
}
exports.validateSerialPortOptions = validateSerialPortOptions;
//# sourceMappingURL=Serial.js.map