import { IOptions } from '../NativeDevice/Hardware/ISerial';
/**
 * Handles open serial port instances via refid references
 *
 * There are multiple places in the application where it's not possible to work with the serial port instances directly
 * because there is an intermediate communication protocol, for example messages from the browser to the server that
 * manage serial ports indirectly. In that case there has to be some way to reference the serial port instances
 * in between the server and the client.
 *
 * One possible way is to have "refid" that is just a string id. This class implements that
 * so both sides can use this class instead of directly working with serial port instances.
 */
interface ISerialPortStore {
    openSerialPort(options: IOptions): Promise<string>;
    writeToSerialPort(refid: string, data: string | number[] | Uint8Array): Promise<void>;
    closeSerialPort(refid: string): Promise<void>;
    closeAllSerialPorts(): Promise<void>;
    on(event: 'data', listener: (refid: string, data: Uint8Array) => void): void;
    on(event: 'close', listener: (refid: string) => void): void;
    removeEventListener(event: 'data' | 'close', listener: (...args: any[]) => void): void;
}
export default ISerialPortStore;
