"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
class MockProximitySensor {
    constructor(window) {
        this.window = window;
        this.mouseInsideWindow = false;
        this.eventEmitter = new events_1.EventEmitter();
        this.listenToMouseEvents();
    }
    addStateChangeListener(callback) {
        this.eventEmitter.addListener('change', callback);
    }
    removeStateChangeListener(callback) {
        this.eventEmitter.removeListener('change', callback);
    }
    listenToMouseEvents() {
        this.window.document.addEventListener('mouseenter', () => {
            if (!this.mouseInsideWindow) {
                this.mouseInsideWindow = true;
                this.eventEmitter.emit('change', true);
            }
        });
        this.window.document.addEventListener('mouseout', (event) => {
            const fromElement = event.relatedTarget;
            if (!fromElement || fromElement.nodeName === 'HTML') {
                this.mouseInsideWindow = false;
                this.eventEmitter.emit('change', false);
            }
        });
    }
}
exports.default = MockProximitySensor;
//# sourceMappingURL=MockProximitySensor.js.map