"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateOverlay = exports.showOverlay = exports.hideOverlay = exports.isOverlayShown = void 0;
const OVERLAY_SHOWN_KEY = 'Screen.Overlay.Shown';
function isOverlayShown(storage) {
    return __awaiter(this, void 0, void 0, function* () {
        return (yield storage.getItem(OVERLAY_SHOWN_KEY)) === '1';
    });
}
exports.isOverlayShown = isOverlayShown;
function hideOverlay(window, storage) {
    return __awaiter(this, void 0, void 0, function* () {
        yield storage.removeItem(OVERLAY_SHOWN_KEY);
        yield updateOverlay(window, storage);
    });
}
exports.hideOverlay = hideOverlay;
function showOverlay(window, storage) {
    return __awaiter(this, void 0, void 0, function* () {
        yield storage.setItem(OVERLAY_SHOWN_KEY, '1');
        yield updateOverlay(window, storage);
    });
}
exports.showOverlay = showOverlay;
function updateOverlay(window, storage) {
    return __awaiter(this, void 0, void 0, function* () {
        const overlayShown = yield storage.getItem(OVERLAY_SHOWN_KEY);
        const overlayId = 'screen-overlay';
        if (!overlayShown) {
            const overlay = window.document.getElementById(overlayId);
            if (overlay && overlay.parentElement) {
                overlay.parentElement.removeChild(overlay);
            }
        }
        else {
            const existingOverlay = window.document.getElementById(overlayId);
            if (!existingOverlay) {
                const overlay = window.document.createElement('div');
                overlay.setAttribute('id', overlayId);
                overlay.style.backgroundColor = '#000000';
                overlay.style.position = 'absolute';
                overlay.style.left = '0';
                overlay.style.top = '0';
                overlay.style.width = '100%';
                overlay.style.height = '100%';
                overlay.style.zIndex = '99999';
                window.document.body.appendChild(overlay);
            }
        }
    });
}
exports.updateOverlay = updateOverlay;
//# sourceMappingURL=overlayHelper.js.map