"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.runPeriodicTaskSagaUntilSuccessWhileOpen = exports.runPeriodicTaskSagaUntilSuccessWhilePlatform = exports.runPeriodicTaskSagaWhileOpen = exports.runPeriodicTaskSagaWhilePlatform = void 0;
const effects_1 = require("redux-saga/effects");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const IConfig_1 = require("../Display/IConfig");
const dependencyInjection_1 = require("../DI/dependencyInjection");
function runPeriodicTaskSagaWhilePlatform(initDelayMs, periodMs, task, options = {}) {
    return runPeriodicTaskSagaWhile(initDelayMs, periodMs, task, IConfig_1.SubscriptionType.platform, options);
}
exports.runPeriodicTaskSagaWhilePlatform = runPeriodicTaskSagaWhilePlatform;
function runPeriodicTaskSagaWhileOpen(initDelayMs, periodMs, task, options = {}) {
    return runPeriodicTaskSagaWhile(initDelayMs, periodMs, task, IConfig_1.SubscriptionType.open, options);
}
exports.runPeriodicTaskSagaWhileOpen = runPeriodicTaskSagaWhileOpen;
function runPeriodicTaskSagaWhile(initDelayMs, periodMs, task, onlyWhenSubscriptionType, options = {}) {
    let secondTelemetryDelayMs = periodMs;
    if (options.randomize) {
        const randomInitialMultiplier = 0.5 + Math.random(); // Random value +/- 50% of the initial delay
        initDelayMs = Math.round(initDelayMs * randomInitialMultiplier);
        secondTelemetryDelayMs = Math.round(Math.random() * periodMs);
    }
    return (0, effects_1.fork)((0, dependencyInjection_1.withDependencies)(['subscriptionType'], function* ({ subscriptionType: currentSubscriptionType }) {
        yield (0, effects_1.call)(wait_1.default, initDelayMs);
        const doTheTask = onlyWhenSubscriptionType === currentSubscriptionType;
        function* invokeTask() {
            if (doTheTask) {
                try {
                    yield task();
                }
                catch (error) {
                    console.error(error);
                }
            }
        }
        // Run the initial telemetry after the initial delay
        yield invokeTask();
        // Do the second telemetry after the initial randomized period
        // to distribute the load on the server
        yield (0, effects_1.call)(wait_1.default, secondTelemetryDelayMs);
        while (true) {
            yield invokeTask();
            yield (0, effects_1.call)(wait_1.default, periodMs);
        }
    }));
}
function runPeriodicTaskSagaUntilSuccessWhilePlatform(initDelayMs, periodMs, task) {
    return runPeriodicTaskSagaUntilSuccessWhile(initDelayMs, periodMs, task, IConfig_1.SubscriptionType.platform);
}
exports.runPeriodicTaskSagaUntilSuccessWhilePlatform = runPeriodicTaskSagaUntilSuccessWhilePlatform;
function runPeriodicTaskSagaUntilSuccessWhileOpen(initDelayMs, periodMs, task) {
    return runPeriodicTaskSagaUntilSuccessWhile(initDelayMs, periodMs, task, IConfig_1.SubscriptionType.open);
}
exports.runPeriodicTaskSagaUntilSuccessWhileOpen = runPeriodicTaskSagaUntilSuccessWhileOpen;
function runPeriodicTaskSagaUntilSuccessWhile(initDelayMs, periodMs, task, onlyWhenSubscriptionType) {
    return (0, effects_1.fork)((0, dependencyInjection_1.withDependencies)(['subscriptionType'], function* ({ subscriptionType: currentSubscriptionType }) {
        yield (0, effects_1.call)(wait_1.default, initDelayMs);
        while (true) {
            const doTheTask = onlyWhenSubscriptionType === currentSubscriptionType;
            if (doTheTask) {
                try {
                    yield task();
                    break;
                }
                catch (error) {
                    // Do nothing
                }
            }
            yield (0, effects_1.call)(wait_1.default, periodMs);
        }
    }));
}
//# sourceMappingURL=periodicTaskSaga.js.map