"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.remoteDesktopSaga = void 0;
const effects_1 = require("redux-saga/effects");
const socketActionCreator_1 = require("../Socket/socketActionCreator");
const DeviceClient_1 = require("@signageos/remote-desktop/es6/RemoteDesktop/DeviceClient/DeviceClient");
const capable_1 = require("../Feature/capable");
const ManagementCapability_1 = __importDefault(require("../NativeDevice/Management/ManagementCapability"));
const dependencyInjection_1 = require("../DI/dependencyInjection");
const remoteDesktopActions_1 = require("@signageos/actions/dist/Device/RemoteDesktop/remoteDesktopActions");
const responsible_1 = require("../Feature/responsible");
const Responsibility_1 = __importDefault(require("../Feature/Responsibility"));
const ManagementCapabilities_1 = require("@signageos/common-types/dist/Device/Capabilities/ManagementCapabilities");
exports.remoteDesktopSaga = (0, responsible_1.whenResponsible)(Responsibility_1.default.REMOTE_DESKTOP, (0, capable_1.whenCapable)(ManagementCapabilities_1.ManagementCapabilities.REMOTE_DESKTOP, remoteDesktopSagaDefault));
function* remoteDesktopSagaDefault() {
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.SCREENSHOT_UPLOAD, (0, dependencyInjection_1.withDependencies)(['managementDriver'], function* ({ managementDriver }) {
        const duid = yield (0, effects_1.call)([managementDriver, managementDriver.getDeviceUid]);
        const resolutionItem = yield (0, effects_1.call)([managementDriver, managementDriver.getResolution]);
        let remoteDesktopClient = null;
        yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(remoteDesktopActions_1.SetRemoteDesktopSettings, function* (action) {
            try {
                if (action.enabled) {
                    if (remoteDesktopClient) {
                        yield remoteDesktopClient.stop();
                    }
                    remoteDesktopClient = new DeviceClient_1.DeviceClient(() => __awaiter(this, void 0, void 0, function* () {
                        return ({
                            screenshotUri: (yield managementDriver.screenshotUpload(action.serverUrl)).url,
                            width: resolutionItem.width,
                            height: resolutionItem.height,
                        });
                    }), duid, managementDriver.input);
                    yield remoteDesktopClient.start({
                        serverUrl: action.serverUrl,
                        frequencyMs: action.frequencyMs,
                    });
                }
                else {
                    if (remoteDesktopClient) {
                        yield remoteDesktopClient.stop();
                        remoteDesktopClient = null;
                    }
                }
                yield (0, effects_1.put)({
                    type: remoteDesktopActions_1.SetRemoteDesktopSettingsSucceeded,
                    uid: action.uid,
                });
            }
            catch (error) {
                yield (0, effects_1.put)({
                    type: remoteDesktopActions_1.SetRemoteDesktopSettingsFailed,
                    uid: action.uid,
                });
            }
        });
    })));
}
//# sourceMappingURL=remoteDesktopSaga.js.map