"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.takeEveryIfPlatform = exports.takeEveryIfOpen = void 0;
const effects_1 = require("redux-saga/effects");
const deviceConfigurationActions_1 = require("../Device/Configuration/deviceConfigurationActions");
const IConfig_1 = require("../Display/IConfig");
function takeEveryIfOpen(pattern, worker) {
    return takeEveryIfSubscriptionType(IConfig_1.SubscriptionType.open, pattern, worker);
}
exports.takeEveryIfOpen = takeEveryIfOpen;
function takeEveryIfPlatform(pattern, worker) {
    return takeEveryIfSubscriptionType(IConfig_1.SubscriptionType.platform, pattern, worker);
}
exports.takeEveryIfPlatform = takeEveryIfPlatform;
function takeEveryIfSubscriptionType(subscriptionType, pattern, worker) {
    return (0, effects_1.fork)(function* () {
        let currentSubscription = IConfig_1.SubscriptionType.open;
        yield (0, effects_1.takeEvery)(deviceConfigurationActions_1.ChangeSubscriptionToOpen, function* () {
            currentSubscription = IConfig_1.SubscriptionType.open;
        });
        yield (0, effects_1.takeEvery)(deviceConfigurationActions_1.ChangeSubscriptionToPlatform, function* () {
            currentSubscription = IConfig_1.SubscriptionType.platform;
        });
        yield (0, effects_1.takeEvery)(pattern, function* (action) {
            if (subscriptionType === currentSubscription) {
                yield worker(action);
            }
        });
    });
}
//# sourceMappingURL=extendedEffects.js.map