"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const circular_json_1 = __importDefault(require("circular-json"));
const createPropertyStorage = (getNativeDriver) => ({
    getValueOrDefault(key, defaultValue) {
        return __awaiter(this, void 0, void 0, function* () {
            const nativeDriver = getNativeDriver();
            try {
                const rawValue = yield nativeDriver.cacheGet(key);
                return JSON.parse(rawValue);
            }
            catch (error) {
                return defaultValue;
            }
        });
    },
    setValue(key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            const nativeDriver = getNativeDriver();
            const rawValue = circular_json_1.default.stringify(value);
            yield nativeDriver.cacheSave(key, rawValue);
        });
    },
    removeValue(key) {
        return __awaiter(this, void 0, void 0, function* () {
            const nativeDriver = getNativeDriver();
            yield nativeDriver.cacheDelete(key);
        });
    },
});
exports.default = createPropertyStorage;
//# sourceMappingURL=propertyStorage.js.map